/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ContextMenuWithNoArrows;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class ASTTreeCell
extends TreeCell<net.sourceforge.pmd.lang.ast.Node> {
    private final MainDesignerController controller;

    public ASTTreeCell(MainDesignerController controller) {
        this.controller = controller;
    }

    private String valueToString(Object value) {
        if (value instanceof String) {
            String stringVal = value.toString();
            stringVal = stringVal.replaceAll("\"", "\\\"");
            stringVal = stringVal.replaceAll("\\$(?=[a-zA-Z{])", "\\${'\\$'}");
            return '\"' + stringVal + '\"';
        }
        if (value instanceof Character) {
            return '\'' + value.toString().replaceAll("'", "\\'") + '\'';
        }
        if (value instanceof Enum) {
            return ((Enum)value).getDeclaringClass().getCanonicalName() + "." + ((Enum)value).name();
        }
        if (value instanceof Class) {
            return ((Class)value).getCanonicalName() + "::class.java";
        }
        if (value instanceof Number || value instanceof Boolean || value == null) {
            return String.valueOf(value);
        }
        return null;
    }

    private void subtreeToNodeTest(net.sourceforge.pmd.lang.ast.Node node, StringBuilder builder, boolean isChild, int indentDepth) {
        int bodyIndent = indentDepth + 4;
        if (isChild) {
            builder.append("child<").append(node.getClass().getSimpleName()).append("> {");
        } else {
            builder.append("<").append(node.getClass().getSimpleName()).append("> {");
        }
        String[] childrenProps = new String[node.jjtGetNumChildren()];
        block2: for (PropertyDescriptor prop : PropertyUtils.getPropertyDescriptors(node.getClass())) {
            Object value;
            if (prop.getReadMethod() == null || !Modifier.isPublic(prop.getReadMethod().getModifiers()) || prop.getReadMethod().getDeclaringClass() != node.getClass()) continue;
            try {
                value = prop.getReadMethod().invoke((Object)node, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            String stringVal = this.valueToString(value);
            if (stringVal != null) {
                String propName;
                String string = propName = value instanceof Boolean && prop.getReadMethod().getName().startsWith("is") ? prop.getReadMethod().getName() : prop.getName();
                if ("XPathNodeName".equals(propName)) continue;
                ASTTreeCell.newLine(builder, bodyIndent).append("it.").append(StringUtils.uncapitalize((String)propName)).append(" shouldBe ").append(stringVal);
                continue;
            }
            if (value instanceof net.sourceforge.pmd.lang.ast.Node) {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    net.sourceforge.pmd.lang.ast.Node child = node.jjtGetChild(i);
                    if (!value.equals(child)) continue;
                    childrenProps[i] = prop.getName();
                    continue block2;
                }
                continue;
            }
            ASTTreeCell.newLine(builder, bodyIndent).append("// it.").append(prop.getName());
        }
        if (node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                net.sourceforge.pmd.lang.ast.Node c = node.jjtGetChild(i);
                ASTTreeCell.newLine(builder, 0);
                ASTTreeCell.newLine(builder, bodyIndent);
                if (childrenProps[i] != null) {
                    builder.append("it.").append(childrenProps[i]).append(" shouldBe ");
                }
                this.subtreeToNodeTest(c, builder, true, bodyIndent);
            }
        }
        ASTTreeCell.newLine(builder, indentDepth).append("}");
    }

    private String dumpToSubtreeTest(net.sourceforge.pmd.lang.ast.Node node) {
        StringBuilder sb = new StringBuilder();
        this.subtreeToNodeTest(node, sb, false, 0);
        String result = sb.toString();
        result = result.replaceAll("\\{\\s*+} ", "{}");
        return result;
    }

    private ContextMenu buildContextMenu(net.sourceforge.pmd.lang.ast.Node item) {
        ContextMenuWithNoArrows contextMenu = new ContextMenuWithNoArrows();
        CustomMenuItem menuItem = new CustomMenuItem((Node)new Label("Copy subtree test to clipboard..."));
        Tooltip tooltip = new Tooltip("Creates a node spec using the Kotlin AST matcher DSL, and dumps it to the clipboard");
        Tooltip.install((Node)menuItem.getContent(), (Tooltip)tooltip);
        menuItem.setOnAction(e -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(this.dumpToSubtreeTest(item));
            clipboard.setContent((Map)content);
        });
        contextMenu.getItems().add((Object)menuItem);
        return contextMenu;
    }

    protected void updateItem(net.sourceforge.pmd.lang.ast.Node item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
            return;
        }
        this.setText(item.toString() + (item.getImage() == null ? "" : " \"" + item.getImage() + "\""));
        this.setContextMenu(this.buildContextMenu(item));
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton() == MouseButton.PRIMARY && ((TreeItem)this.getTreeView().getSelectionModel().getSelectedItem()).getValue() == item) {
                this.controller.onNodeItemSelected(item);
                t.consume();
            }
        });
    }

    private static StringBuilder newLine(StringBuilder builder, int indentDepth) {
        return builder.append("\n").append(StringUtils.repeat((char)' ', (int)indentDepth));
    }
}

