/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.NodeStyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class UniformStyleCollection {
    private static final Map<Set<String>, Map<Integer, Map<Boolean, Set<String>>>> DEPTH_STYLE_CACHE = new HashMap<Set<String>, Map<Integer, Map<Boolean, Set<String>>>>();
    private final Set<String> style;
    private final List<NodeStyleSpan> nodes;
    private StyleSpans<Collection<String>> spanCache;

    public UniformStyleCollection(Set<String> style, Collection<NodeStyleSpan> ns) {
        this.style = style;
        this.nodes = new ArrayList<NodeStyleSpan>(ns);
        this.nodes.sort(NodeStyleSpan.documentOrderComparator());
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Set<String> getStyle() {
        return this.style;
    }

    public UniformStyleCollection merge(UniformStyleCollection collection) {
        assert (collection.getStyle().equals(this.getStyle()));
        if (collection.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return collection;
        }
        HashSet<NodeStyleSpan> merged = new HashSet<NodeStyleSpan>(this.nodes);
        merged.addAll(collection.nodes);
        return new UniformStyleCollection(this.style, merged);
    }

    private boolean useInlineHighlight(Node node) {
        return node.getBeginLine() == node.getEndLine();
    }

    private Set<String> styleForDepth(int depth, NodeStyleSpan.PositionSnapshot n) {
        return this.styleForDepth(depth, n != null && this.useInlineHighlight(n.getNode()));
    }

    private Set<String> styleForDepth(int depth, boolean inlineHighlight) {
        if (depth < 0) {
            return Collections.emptySet();
        }
        DEPTH_STYLE_CACHE.putIfAbsent(this.style, new HashMap());
        Map<Integer, Map<Boolean, Set<String>>> depthToStyle = DEPTH_STYLE_CACHE.get(this.style);
        depthToStyle.putIfAbsent(depth, new HashMap());
        Map<Boolean, Set<String>> isInlineToStyle = depthToStyle.get(depth);
        if (isInlineToStyle.containsKey(inlineHighlight)) {
            return isInlineToStyle.get(inlineHighlight);
        }
        HashSet<String> s = new HashSet<String>(this.style);
        s.add("depth-" + depth);
        if (inlineHighlight) {
            s.add("inline-highlight");
        }
        isInlineToStyle.put(inlineHighlight, s);
        return s;
    }

    public StyleSpans<Collection<String>> toSpans() {
        if (this.spanCache == null) {
            this.spanCache = this.buildSpans();
        }
        return this.spanCache;
    }

    public StyleSpans<Collection<String>> buildSpans() {
        if (this.nodes.isEmpty()) {
            return StyleSpans.singleton(Collections.emptyList(), (int)0);
        }
        if (this.nodes.size() == 1) {
            NodeStyleSpan.PositionSnapshot snapshot = this.nodes.get(0).snapshot();
            return new StyleSpansBuilder().add(Collections.emptyList(), snapshot.getBeginIndex()).add(this.styleForDepth(0, snapshot), snapshot.getLength()).create();
        }
        StyleSpansBuilder builder = new StyleSpansBuilder();
        ArrayDeque<NodeStyleSpan.PositionSnapshot> overlappingNodes = new ArrayDeque<NodeStyleSpan.PositionSnapshot>();
        NodeStyleSpan.PositionSnapshot previous = null;
        int lastSpanEnd = 0;
        for (NodeStyleSpan span : this.nodes) {
            NodeStyleSpan.PositionSnapshot current = span.snapshot();
            if (current == null) continue;
            if (previous == null) {
                previous = current;
                builder.add(Collections.emptyList(), previous.getBeginIndex());
                lastSpanEnd = previous.getBeginIndex();
                continue;
            }
            if (previous.getEndIndex() > current.getBeginIndex()) {
                builder.add(this.styleForDepth(overlappingNodes.size() - 1, (NodeStyleSpan.PositionSnapshot)overlappingNodes.peek()), previous.getBeginIndex() - lastSpanEnd);
                builder.add(this.styleForDepth(overlappingNodes.size(), current), current.getBeginIndex() - previous.getBeginIndex());
                lastSpanEnd = current.getBeginIndex();
                overlappingNodes.addFirst(previous);
                previous = current;
                continue;
            }
            builder.add(this.styleForDepth(overlappingNodes.size() - 1, (NodeStyleSpan.PositionSnapshot)overlappingNodes.peek()), previous.getBeginIndex() - lastSpanEnd);
            builder.add(this.styleForDepth(overlappingNodes.size(), previous), previous.getLength());
            lastSpanEnd = previous.getEndIndex();
            previous = current;
            Iterator overlaps = overlappingNodes.iterator();
            while (overlaps.hasNext()) {
                NodeStyleSpan.PositionSnapshot enclosing = (NodeStyleSpan.PositionSnapshot)overlaps.next();
                if (enclosing.getEndIndex() >= current.getBeginIndex()) continue;
                overlaps.remove();
                builder.add(this.styleForDepth(overlappingNodes.size(), enclosing), enclosing.getEndIndex() - lastSpanEnd);
                lastSpanEnd = enclosing.getEndIndex();
            }
        }
        builder.add(this.styleForDepth(overlappingNodes.size() - 1, (NodeStyleSpan.PositionSnapshot)overlappingNodes.peek()), previous.getBeginIndex() - lastSpanEnd);
        builder.add(this.styleForDepth(overlappingNodes.size(), previous), previous.getLength());
        lastSpanEnd = previous.getEndIndex();
        int depth = overlappingNodes.size();
        for (NodeStyleSpan.PositionSnapshot enclosing : overlappingNodes) {
            builder.add(this.styleForDepth(--depth, enclosing), enclosing.getEndIndex() - lastSpanEnd);
            lastSpanEnd = enclosing.getEndIndex();
        }
        return builder.create();
    }

    public static UniformStyleCollection empty() {
        return new UniformStyleCollection(Collections.emptySet(), Collections.emptySet());
    }
}

