/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlighter;
import org.apache.commons.lang3.RandomStringUtils;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public abstract class SimpleRegexSyntaxHighlighter
implements SyntaxHighlighter {
    private final RegexHighlightGrammar grammar;
    private final String languageName;

    protected SimpleRegexSyntaxHighlighter(String languageName, RegexHighlightGrammar grammar) {
        this.grammar = grammar;
        this.languageName = languageName;
        grammar.addCommonClass("code");
        grammar.addCommonClass(languageName);
    }

    @Override
    public StyleSpans<Collection<String>> computeHighlighting(String text) {
        StyleSpansBuilder builder = new StyleSpansBuilder();
        Matcher matcher = this.grammar.getMatcher(text);
        int lastKwEnd = 0;
        Set<String> onlyLang = Collections.singleton(this.languageName);
        try {
            while (matcher.find()) {
                Set<String> styleClasses = this.grammar.getCssClassesOfLastGroup(matcher);
                builder.add(onlyLang, matcher.start() - lastKwEnd);
                builder.add(styleClasses, matcher.end() - matcher.start());
                lastKwEnd = matcher.end();
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        builder.add(onlyLang, text.length() - lastKwEnd);
        return builder.create();
    }

    @Override
    public final String getLanguageTerseName() {
        return this.languageName;
    }

    protected static String alternation(String[] alternatives) {
        String firstChars = Arrays.stream(alternatives).map(s -> s.substring(0, 1)).distinct().reduce((s1, s2) -> s1 + s2).get();
        String alt = "(?=[" + firstChars + "])(?:" + String.join((CharSequence)"|", alternatives) + ")";
        return SimpleRegexSyntaxHighlighter.asWord(alt);
    }

    protected static String asWord(String regex) {
        return "(?:\\b" + regex + "\\b)";
    }

    protected static RegexHighlightGrammarBuilder grammarBuilder(Collection<String> cssClass, String pattern) {
        return new RegexHighlightGrammarBuilder(cssClass, pattern);
    }

    protected static class RegexHighlightGrammar {
        private final Pattern pattern;
        private final Map<String, Set<String>> namesToCssClass;

        RegexHighlightGrammar(Pattern pattern, Map<String, Set<String>> namesToCssClass) {
            this.pattern = pattern;
            this.namesToCssClass = namesToCssClass;
        }

        Matcher getMatcher(String text) {
            return this.pattern.matcher(text);
        }

        void addCommonClass(String css) {
            this.namesToCssClass.values().forEach(e -> e.add(css));
        }

        Set<String> getCssClassesOfLastGroup(Matcher matcher) {
            for (Map.Entry<String, Set<String>> groupToClass : this.namesToCssClass.entrySet()) {
                if (matcher.group(groupToClass.getKey()) == null) continue;
                return groupToClass.getValue();
            }
            return Collections.emptySet();
        }
    }

    protected static final class RegexHighlightGrammarBuilder {
        private Map<String, String> groupNameToRegex = new LinkedHashMap<String, String>();
        private Map<String, Set<String>> groupNameToCssClasses = new LinkedHashMap<String, Set<String>>();

        RegexHighlightGrammarBuilder(Collection<String> cssClass, String regex) {
            this.or(cssClass, regex);
        }

        public RegexHighlightGrammarBuilder or(Collection<String> cssClass, String regex) {
            String groupName = RandomStringUtils.randomAlphabetic((int)8);
            this.groupNameToRegex.put(groupName, regex);
            this.groupNameToCssClasses.put(groupName, new HashSet<String>(cssClass));
            return this;
        }

        private String namedGroup(String name, String regex) {
            return "(?<" + name + ">(?:" + regex + "))";
        }

        private String getRegexString() {
            return String.join((CharSequence)"|", this.groupNameToRegex.entrySet().stream().map(e -> this.namedGroup((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        }

        public RegexHighlightGrammar create() {
            return new RegexHighlightGrammar(Pattern.compile(this.getRegexString()), this.getGroupNamesToCssClasses());
        }

        public RegexHighlightGrammar create(int flags) {
            return new RegexHighlightGrammar(Pattern.compile(this.getRegexString(), flags), this.getGroupNamesToCssClasses());
        }

        private Map<String, Set<String>> getGroupNamesToCssClasses() {
            return Collections.unmodifiableMap(this.groupNameToCssClasses);
        }
    }
}

