/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Arrays;
import java.util.Optional;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.ApexSyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.JavaSyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.XPathSyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.XmlSyntaxHighlighter;

public enum AvailableSyntaxHighlighters {
    JAVA("java", new JavaSyntaxHighlighter()),
    APEX("apex", new ApexSyntaxHighlighter()),
    XML("xml", new XmlSyntaxHighlighter()),
    XSL("xsl", new XmlSyntaxHighlighter()),
    WSDL("wsdl", new XmlSyntaxHighlighter()),
    POM("pom", new XmlSyntaxHighlighter()),
    XPATH("xpath", new XPathSyntaxHighlighter());

    private final String language;
    private final SyntaxHighlighter engine;

    private AvailableSyntaxHighlighters(String languageTerseName, SyntaxHighlighter engine) {
        this.language = languageTerseName;
        this.engine = engine;
    }

    public static Optional<SyntaxHighlighter> getHighlighterForLanguage(Language language) {
        return Arrays.stream(AvailableSyntaxHighlighters.values()).filter(e -> e.language.equals(language.getTerseName())).findFirst().map(h -> h.engine);
    }
}

