/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanModelNodeSeq;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanNodeVisitor;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SimpleBeanModelNode;
import net.sourceforge.pmd.util.fxdesigner.util.beans.XmlInterface;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ClassUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlInterfaceVersion1
extends XmlInterface {
    private static final String SCHEMA_NODE_ELEMENT = "node";
    private static final String SCHEMA_NODESEQ_ELEMENT = "nodeseq";
    private static final String SCHEMA_NODE_CLASS_ATTRIBUTE = "class";
    private static final String SCHEMA_PROPERTY_ELEMENT = "property";
    private static final String SCHEMA_PROPERTY_NAME = "name";
    private static final String SCHEMA_PROPERTY_TYPE = "type";

    public XmlInterfaceVersion1(int revisionNumber) {
        super(revisionNumber);
    }

    private List<Element> getChildrenByTagName(Element element, String tagName) {
        NodeList children = element.getChildNodes();
        ArrayList<Element> elts = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1 || !tagName.equals(children.item(i).getNodeName())) continue;
            elts.add((Element)children.item(i));
        }
        return elts;
    }

    @Override
    protected SimpleBeanModelNode parseSettingsOwnerNode(Element nodeElement) {
        Class<?> clazz;
        try {
            clazz = Class.forName(nodeElement.getAttribute(SCHEMA_NODE_CLASS_ATTRIBUTE));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        SimpleBeanModelNode node = new SimpleBeanModelNode(clazz);
        for (Element setting : this.getChildrenByTagName(nodeElement, SCHEMA_PROPERTY_ELEMENT)) {
            this.parseSingleProperty(setting, node);
        }
        for (Element child : this.getChildrenByTagName(nodeElement, SCHEMA_NODE_ELEMENT)) {
            try {
                if (node.getChildrenByType().get(Class.forName(child.getAttribute(SCHEMA_NODE_CLASS_ATTRIBUTE))) != null) continue;
                node.addChild(this.parseSettingsOwnerNode(child));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (Element seq : this.getChildrenByTagName(nodeElement, SCHEMA_NODESEQ_ELEMENT)) {
            this.parseNodeSeq(seq, node);
        }
        return node;
    }

    private void parseSingleProperty(Element propertyElement, SimpleBeanModelNode owner) {
        Class type;
        String typeName = propertyElement.getAttribute(SCHEMA_PROPERTY_TYPE);
        String name = propertyElement.getAttribute(SCHEMA_PROPERTY_NAME);
        try {
            type = ClassUtils.getClass((String)typeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        ConvertUtils.convert((Object)new Object());
        Object value = ConvertUtils.convert((String)propertyElement.getTextContent(), (Class)type);
        owner.addProperty(name, value, type);
    }

    private void parseNodeSeq(Element nodeSeq, SimpleBeanModelNode parent) {
        BeanModelNodeSeq<SimpleBeanModelNode> built = new BeanModelNodeSeq<SimpleBeanModelNode>(nodeSeq.getAttribute(SCHEMA_PROPERTY_NAME));
        for (Element child : this.getChildrenByTagName(nodeSeq, SCHEMA_NODE_ELEMENT)) {
            built.addChild(this.parseSettingsOwnerNode(child));
        }
        parent.addChild(built);
    }

    @Override
    protected BeanNodeVisitor<Element> getDocumentMakerVisitor() {
        return new DocumentMakerVisitor();
    }

    public static class DocumentMakerVisitor
    extends BeanNodeVisitor<Element> {
        @Override
        public void visit(SimpleBeanModelNode node, Element parent) {
            Element nodeElement = parent.getOwnerDocument().createElement(XmlInterfaceVersion1.SCHEMA_NODE_ELEMENT);
            nodeElement.setAttribute(XmlInterfaceVersion1.SCHEMA_NODE_CLASS_ATTRIBUTE, node.getNodeType().getCanonicalName());
            for (Map.Entry<String, Object> keyValue : node.getSettingsValues().entrySet()) {
                String value = (String)ConvertUtils.lookup(keyValue.getValue().getClass()).convert(String.class, keyValue.getValue());
                if (value == null) continue;
                Element setting = parent.getOwnerDocument().createElement(XmlInterfaceVersion1.SCHEMA_PROPERTY_ELEMENT);
                setting.setAttribute(XmlInterfaceVersion1.SCHEMA_PROPERTY_NAME, keyValue.getKey());
                setting.setAttribute(XmlInterfaceVersion1.SCHEMA_PROPERTY_TYPE, node.getSettingsTypes().get(keyValue.getKey()).getCanonicalName());
                setting.appendChild(parent.getOwnerDocument().createCDATASection(value));
                nodeElement.appendChild(setting);
            }
            parent.appendChild(nodeElement);
            super.visit(node, nodeElement);
        }

        @Override
        public void visit(BeanModelNodeSeq<?> node, Element parent) {
            Element nodeElement = parent.getOwnerDocument().createElement(XmlInterfaceVersion1.SCHEMA_NODESEQ_ELEMENT);
            nodeElement.setAttribute(XmlInterfaceVersion1.SCHEMA_PROPERTY_NAME, node.getPropertyName());
            parent.appendChild(nodeElement);
            super.visit(node, nodeElement);
        }
    }
}

