/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.beans;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanNodeVisitor;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SimpleBeanModelNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XmlInterface {
    private static final String SCHEMA_MODEL_VERSION = "revision";
    private static final String SCHEMA_DOCUMENT_ELEMENT = "designer-settings";
    private final int revisionNumber;

    public XmlInterface(int rev) {
        this.revisionNumber = rev;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public final Optional<SimpleBeanModelNode> parseXml(Document document) {
        if (this.canParse(document)) {
            Element rootNodeElement = (Element)document.getDocumentElement().getChildNodes().item(1);
            return Optional.ofNullable(this.parseSettingsOwnerNode(rootNodeElement));
        }
        return Optional.empty();
    }

    public boolean canParse(Document document) {
        int docVersion = Integer.parseInt(document.getDocumentElement().getAttribute(SCHEMA_MODEL_VERSION));
        return docVersion == this.getRevisionNumber();
    }

    private Document initDocument() throws IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Failed to create settings document builder", e);
        }
        Document document = documentBuilder.newDocument();
        Element settingsElement = document.createElement(SCHEMA_DOCUMENT_ELEMENT);
        settingsElement.setAttribute(SCHEMA_MODEL_VERSION, "" + this.getRevisionNumber());
        document.appendChild(settingsElement);
        return document;
    }

    private void save(Document document, File outputFile) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            outputFile.getParentFile().mkdirs();
            StreamResult result = new StreamResult(Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Failed to save settings", e);
        }
    }

    public final void writeModelToXml(File output, SimpleBeanModelNode model) throws IOException {
        Document document = this.initDocument();
        model.accept(this.getDocumentMakerVisitor(), document.getDocumentElement());
        this.save(document, output);
    }

    protected abstract SimpleBeanModelNode parseSettingsOwnerNode(Element var1);

    protected abstract BeanNodeVisitor<Element> getDocumentMakerVisitor();
}

