/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.beans;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.properties.PropertyTypeId;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanModelNode;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanModelNodeSeq;
import net.sourceforge.pmd.util.fxdesigner.util.beans.RestorePropertyVisitor;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SimpleBeanModelNode;
import net.sourceforge.pmd.util.fxdesigner.util.beans.XmlInterface;
import net.sourceforge.pmd.util.fxdesigner.util.beans.XmlInterfaceVersion1;
import net.sourceforge.pmd.util.fxdesigner.util.beans.converters.LanguageVersionConverter;
import net.sourceforge.pmd.util.fxdesigner.util.beans.converters.PropertyTypeIdConverter;
import net.sourceforge.pmd.util.fxdesigner.util.beans.converters.RulePriorityConverter;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class SettingsPersistenceUtil {
    private SettingsPersistenceUtil() {
    }

    public static void restoreProperties(SettingsOwner root, File file) {
        Optional<Document> odoc = SettingsPersistenceUtil.getDocument(file);
        odoc.flatMap(XmlFormatRevision::getSuitableReader).map(rev -> ((XmlFormatRevision)rev).xmlInterface).flatMap(xmlInterface -> odoc.flatMap(xmlInterface::parseXml)).ifPresent(n -> SettingsPersistenceUtil.restoreSettings(root, n));
    }

    public static void persistProperties(SettingsOwner root, File file) throws IOException {
        SimpleBeanModelNode node = SettingsPersistenceUtil.buildSettingsModel(root);
        XmlFormatRevision.getLatest().xmlInterface.writeModelToXml(file, node);
    }

    private static Optional<Document> getDocument(File file) {
        if (file.exists()) {
            Optional<Document> optional;
            block9: {
                InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = builder.parse(stream);
                    optional = Optional.of(document);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        e.printStackTrace();
                    }
                }
                stream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    static SimpleBeanModelNode buildSettingsModel(SettingsOwner root) {
        SimpleBeanModelNode node = new SimpleBeanModelNode(root.getClass());
        for (PropertyDescriptor d : PropertyUtils.getPropertyDescriptors((Object)root)) {
            if (d.getReadMethod() == null) continue;
            try {
                if (d.getReadMethod().isAnnotationPresent(PersistentSequence.class)) {
                    Object val = d.getReadMethod().invoke((Object)root, new Object[0]);
                    if (!Collection.class.isAssignableFrom(val.getClass())) continue;
                    Collection values = (Collection)val;
                    BeanModelNodeSeq<SimpleBeanModelNode> seq = new BeanModelNodeSeq<SimpleBeanModelNode>(d.getName());
                    for (SettingsOwner item : values) {
                        seq.addChild(SettingsPersistenceUtil.buildSettingsModel(item));
                    }
                    node.addChild(seq);
                    continue;
                }
                if (!d.getReadMethod().isAnnotationPresent(PersistentProperty.class)) continue;
                node.addProperty(d.getName(), d.getReadMethod().invoke((Object)root, new Object[0]), d.getPropertyType());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (SettingsOwner child : root.getChildrenSettingsNodes()) {
            node.addChild(SettingsPersistenceUtil.buildSettingsModel(child));
        }
        return node;
    }

    static void restoreSettings(SettingsOwner target, BeanModelNode model) {
        if (model == null) {
            return;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        model.accept(new RestorePropertyVisitor(), target);
    }

    static {
        ConvertUtils.register((Converter)new RulePriorityConverter(), RulePriority.class);
        ConvertUtils.register((Converter)new PropertyTypeIdConverter(), PropertyTypeId.class);
        ConvertUtils.register((Converter)new LanguageVersionConverter(), LanguageVersion.class);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PersistentSequence {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PersistentProperty {
    }

    private static enum XmlFormatRevision implements Comparable<XmlFormatRevision>
    {
        V1(new XmlInterfaceVersion1(1));

        private final XmlInterface xmlInterface;

        private XmlFormatRevision(XmlInterface xmlI) {
            this.xmlInterface = xmlI;
        }

        public static XmlFormatRevision getLatest() {
            return Arrays.stream(XmlFormatRevision.values()).max(Comparator.comparingInt(x -> x.xmlInterface.getRevisionNumber())).get();
        }

        public static Optional<XmlFormatRevision> getSuitableReader(Document doc) {
            return Arrays.stream(XmlFormatRevision.values()).filter(rev -> rev.xmlInterface.canParse(doc)).findAny();
        }
    }
}

