/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.Language;

public class XPathSuggestions {
    private List<String> availableNodeNames = new ArrayList<String>();

    public XPathSuggestions(Language language) {
        try {
            this.availableNodeNames = this.createList(XPathSuggestions.getClasses("net.sourceforge.pmd.lang." + language.getTerseName() + ".ast"));
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public List<String> getXPathSuggestions(String input) {
        return this.availableNodeNames.stream().filter(s -> s.contains(input)).collect(Collectors.toList());
    }

    private List<String> createList(Class[] classArray) {
        return Arrays.asList(classArray).stream().filter(files -> files.getSimpleName().startsWith("AST")).map(m -> m.getSimpleName().substring("AST".length())).collect(Collectors.toList());
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(XPathSuggestions.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[0]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - ".class".length())));
        }
        return classes;
    }
}

