/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.util.datasource.DataSource;

public class ZipDataSource
implements DataSource {
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;

    public ZipDataSource(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.zipFile.getInputStream(this.zipEntry);
    }

    @Override
    public String getNiceFileName(boolean shortNames, String inputFileName) {
        return this.zipFile.getName() + ":" + this.zipEntry.getName();
    }

    public String toString() {
        return ZipDataSource.class.getSimpleName() + '[' + this.zipFile.getName() + '!' + this.zipEntry.getName() + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.zipEntry == null ? 0 : this.zipEntry.getName().hashCode());
        result = 31 * result + (this.zipFile == null ? 0 : this.zipFile.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZipDataSource other = (ZipDataSource)obj;
        if (this.zipEntry == null ? other.zipEntry != null : !this.zipEntry.getName().equals(other.zipEntry.getName())) {
            return false;
        }
        return !(this.zipFile == null ? other.zipFile != null : !this.zipFile.getName().equals(other.zipFile.getName()));
    }
}

