/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.AbstractDelegateRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.StringUtil;

public class RuleReference
extends AbstractDelegateRule {
    private Language language;
    private LanguageVersion minimumLanguageVersion;
    private LanguageVersion maximumLanguageVersion;
    private Boolean deprecated;
    private String name;
    private List<PropertyDescriptor<?>> propertyDescriptors;
    private Map<PropertyDescriptor<?>, Object> propertyValues;
    private String message;
    private String description;
    private List<String> examples;
    private String externalInfoUrl;
    private RulePriority priority;
    private RuleSetReference ruleSetReference;

    @Deprecated
    public RuleReference() {
    }

    public RuleReference(Rule theRule, RuleSetReference theRuleSetReference) {
        this.setRule(theRule);
        this.ruleSetReference = theRuleSetReference;
    }

    private RuleReference(RuleReference ref) {
        this.language = ref.language;
        this.minimumLanguageVersion = ref.minimumLanguageVersion;
        this.maximumLanguageVersion = ref.maximumLanguageVersion;
        this.deprecated = ref.deprecated;
        this.name = ref.name;
        this.propertyDescriptors = ref.propertyDescriptors;
        this.propertyValues = ref.propertyValues == null ? null : new HashMap(ref.propertyValues);
        this.message = ref.message;
        this.description = ref.description;
        this.examples = ref.examples == null ? null : new ArrayList<String>(ref.examples);
        this.externalInfoUrl = ref.externalInfoUrl;
        this.priority = ref.priority;
        this.ruleSetReference = ref.ruleSetReference;
        this.setRule(ref.getRule().deepCopy());
    }

    public Language getOverriddenLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(Language language) {
        if (!Objects.equals(language, super.getLanguage()) || this.language != null) {
            this.language = language;
            super.setLanguage(language);
        }
    }

    public LanguageVersion getOverriddenMinimumLanguageVersion() {
        return this.minimumLanguageVersion;
    }

    @Override
    public void setMinimumLanguageVersion(LanguageVersion minimumLanguageVersion) {
        if (!Objects.equals(minimumLanguageVersion, super.getMinimumLanguageVersion()) || this.minimumLanguageVersion != null) {
            this.minimumLanguageVersion = minimumLanguageVersion;
            super.setMinimumLanguageVersion(minimumLanguageVersion);
        }
    }

    public LanguageVersion getOverriddenMaximumLanguageVersion() {
        return this.maximumLanguageVersion;
    }

    @Override
    public void setMaximumLanguageVersion(LanguageVersion maximumLanguageVersion) {
        if (!Objects.equals(maximumLanguageVersion, super.getMaximumLanguageVersion()) || this.maximumLanguageVersion != null) {
            this.maximumLanguageVersion = maximumLanguageVersion;
            super.setMaximumLanguageVersion(maximumLanguageVersion);
        }
    }

    public Boolean isOverriddenDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated != false;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated ? Boolean.valueOf(deprecated) : null;
    }

    public String getOverriddenName() {
        return this.name;
    }

    public String getOriginalName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        if (!RuleReference.isSame(name, super.getName()) || this.name != null) {
            this.name = name;
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    public String getOverriddenMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        if (!RuleReference.isSame(message, super.getMessage()) || this.message != null) {
            this.message = message;
            super.setMessage(message);
        }
    }

    public String getOverriddenDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (!RuleReference.isSame(description, super.getDescription()) || this.description != null) {
            this.description = description;
            super.setDescription(description);
        }
    }

    public List<String> getOverriddenExamples() {
        return this.examples;
    }

    @Override
    public void addExample(String example) {
        if (!RuleReference.contains(super.getExamples(), example)) {
            if (this.examples == null) {
                this.examples = new ArrayList<String>(1);
            }
            this.examples.clear();
            this.examples.add(example);
            super.addExample(example);
        }
    }

    public String getOverriddenExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String externalInfoUrl) {
        if (!RuleReference.isSame(externalInfoUrl, super.getExternalInfoUrl()) || this.externalInfoUrl != null) {
            this.externalInfoUrl = externalInfoUrl;
            super.setExternalInfoUrl(externalInfoUrl);
        }
    }

    public RulePriority getOverriddenPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(RulePriority priority) {
        if (priority != super.getPriority() || this.priority != null) {
            this.priority = priority;
            super.setPriority(priority);
        }
    }

    @Override
    public List<PropertyDescriptor<?>> getOverriddenPropertyDescriptors() {
        return this.propertyDescriptors == null ? Collections.emptyList() : new ArrayList(this.propertyDescriptors);
    }

    @Override
    public void definePropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) throws IllegalArgumentException {
        super.definePropertyDescriptor(propertyDescriptor);
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new ArrayList();
        }
        this.propertyDescriptors.add(propertyDescriptor);
    }

    @Override
    public Map<PropertyDescriptor<?>, Object> getOverriddenPropertiesByPropertyDescriptor() {
        return this.propertyValues == null ? new HashMap() : new HashMap(this.propertyValues);
    }

    @Override
    public <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T value) {
        if (!Objects.equals(super.getProperty(propertyDescriptor), value)) {
            if (this.propertyValues == null) {
                this.propertyValues = new HashMap();
            }
            this.propertyValues.put(propertyDescriptor, value);
            super.setProperty(propertyDescriptor, value);
        }
    }

    public RuleSetReference getRuleSetReference() {
        return this.ruleSetReference;
    }

    @Deprecated
    public void setRuleSetReference(RuleSetReference ruleSetReference) {
        this.ruleSetReference = ruleSetReference;
    }

    private static boolean isSame(String s1, String s2) {
        return StringUtil.isSame(s1, s2, true, false, true);
    }

    private static boolean contains(Collection<String> collection, String s1) {
        for (String s2 : collection) {
            if (!RuleReference.isSame(s1, s2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDescriptor(PropertyDescriptor<?> descriptor) {
        return this.propertyDescriptors != null && this.propertyDescriptors.contains(descriptor) || super.hasDescriptor(descriptor);
    }

    @Deprecated
    public boolean hasOverriddenProperty(PropertyDescriptor<?> descriptor) {
        return this.isPropertyOverridden(descriptor);
    }

    @Override
    public boolean isPropertyOverridden(PropertyDescriptor<?> descriptor) {
        return this.propertyValues != null && this.propertyValues.containsKey(descriptor);
    }

    @Override
    @Deprecated
    public boolean usesDefaultValues() {
        List<PropertyDescriptor<?>> descriptors = this.getOverriddenPropertyDescriptors();
        if (!descriptors.isEmpty()) {
            return false;
        }
        for (PropertyDescriptor<?> desc : descriptors) {
            if (Objects.equals(desc.defaultValue(), this.getProperty(desc))) continue;
            return false;
        }
        return this.getRule().usesDefaultValues();
    }

    @Override
    @Deprecated
    public void useDefaultValueFor(PropertyDescriptor<?> desc) {
        this.getRule().useDefaultValueFor(desc);
        if (this.propertyValues == null) {
            return;
        }
        this.propertyValues.remove(desc);
        if (this.propertyDescriptors != null) {
            this.propertyDescriptors.remove(desc);
        }
    }

    @Override
    public Rule deepCopy() {
        return new RuleReference(this);
    }
}

