/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;

public class Attribute {
    private static final Logger LOG = Logger.getLogger(Attribute.class.getName());
    private static final ConcurrentMap<String, Boolean> DETECTED_DEPRECATED_ATTRIBUTES = new ConcurrentHashMap<String, Boolean>();
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private Node parent;
    private String name;
    private Method method;
    private Object value;
    private String stringValue;

    public Attribute(Node parent, String name, Method m) {
        this.parent = parent;
        this.name = name;
        this.method = m;
    }

    public Attribute(Node parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = value;
        this.stringValue = value;
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.method.isAnnotationPresent(Deprecated.class) && LOG.isLoggable(Level.WARNING) && DETECTED_DEPRECATED_ATTRIBUTES.putIfAbsent(this.getLoggableAttributeName(), Boolean.TRUE) == null) {
            LOG.warning("Use of deprecated attribute '" + this.getLoggableAttributeName() + "' in XPath query");
        }
        try {
            this.value = this.method.invoke((Object)this.parent, EMPTY_OBJ_ARRAY);
            return this.value;
        }
        catch (IllegalAccessException | InvocationTargetException iae) {
            iae.printStackTrace();
            return null;
        }
    }

    public String getStringValue() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        Object v = this.value;
        if (this.value == null) {
            v = this.getValue();
        }
        this.stringValue = v == null ? "" : String.valueOf(v);
        return this.stringValue;
    }

    private String getLoggableAttributeName() {
        return this.parent.getXPathNodeName() + "/@" + this.name;
    }

    public String toString() {
        return this.name + ':' + this.getValue() + ':' + this.parent;
    }
}

