/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.StackTrace;

public final class CallPoint
implements Serializable {
    private static final long serialVersionUID = 362727169057343840L;
    private static final Map<StackTraceElement, Boolean> steCache;
    private static final Class<? extends Annotation> testAnnotation;
    private static final boolean checkTestAnnotationOnClass;
    private static final boolean checkIfTestCaseSubclass;
    @Nonnull
    private final StackTraceElement ste;
    private int repetitionCount;

    @Nullable
    private static Class<?> getTestNGAnnotationIfAvailable() {
        try {
            return Class.forName("org.testng.annotations.Test");
        }
        catch (ClassNotFoundException ignore) {
            try {
                return Class.forName("org.testng.Test");
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
        }
    }

    private static boolean checkForJUnit3Availability() {
        try {
            Class.forName("junit.framework.TestCase");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    private CallPoint(@Nonnull StackTraceElement ste) {
        this.ste = ste;
    }

    @Nonnull
    public StackTraceElement getStackTraceElement() {
        return this.ste;
    }

    public int getRepetitionCount() {
        return this.repetitionCount;
    }

    public void incrementRepetitionCount() {
        ++this.repetitionCount;
    }

    public boolean isSameTestMethod(@Nonnull CallPoint other) {
        StackTraceElement thisSTE = this.ste;
        StackTraceElement otherSTE = other.ste;
        return thisSTE == otherSTE || thisSTE.getClassName().equals(otherSTE.getClassName()) && thisSTE.getMethodName().equals(otherSTE.getMethodName());
    }

    public boolean isSameLineInTestCode(@Nonnull CallPoint other) {
        return this.isSameTestMethod(other) && this.ste.getLineNumber() == other.ste.getLineNumber();
    }

    @Nullable
    static CallPoint create(@Nonnull Throwable newThrowable) {
        StackTrace st = new StackTrace(newThrowable);
        int n = st.getDepth();
        for (int i = 2; i < n; ++i) {
            StackTraceElement ste = st.getElement(i);
            if (!CallPoint.isTestMethod(ste)) continue;
            return new CallPoint(ste);
        }
        return null;
    }

    private static boolean isTestMethod(@Nonnull StackTraceElement ste) {
        Class<?> aClass;
        String className = ste.getClassName();
        String methodName = ste.getMethodName();
        if (className == null || methodName == null) {
            return false;
        }
        if (steCache.containsKey(ste)) {
            return steCache.get(ste);
        }
        boolean isTestMethod = false;
        if (ste.getFileName() != null && ste.getLineNumber() >= 0 && !CallPoint.isClassInExcludedPackage(className) && (aClass = CallPoint.loadClass(className)) != null) {
            isTestMethod = CallPoint.isTestMethod(aClass, methodName);
        }
        steCache.put(ste, isTestMethod);
        return isTestMethod;
    }

    private static boolean isClassInExcludedPackage(@Nonnull String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("org.junit.") || className.startsWith("org.testng.") || className.startsWith("mockit.");
    }

    @Nullable
    private static Class<?> loadClass(@Nonnull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | LinkageError ignore) {
            return null;
        }
    }

    private static boolean isTestMethod(@Nonnull Class<?> testClass, @Nonnull String methodName) {
        if (checkTestAnnotationOnClass && testClass.isAnnotationPresent(testAnnotation)) {
            return true;
        }
        Method method = CallPoint.findMethod(testClass, methodName);
        return method != null && (CallPoint.containsATestFrameworkAnnotation(method.getDeclaredAnnotations()) || checkIfTestCaseSubclass && CallPoint.isJUnit3xTestMethod(testClass, method));
    }

    @Nullable
    private static Method findMethod(@Nonnull Class<?> aClass, @Nonnull String name) {
        try {
            for (Method method : aClass.getDeclaredMethods()) {
                if (method.getReturnType() != Void.TYPE || !name.equals(method.getName())) continue;
                return method;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    private static boolean containsATestFrameworkAnnotation(@Nonnull Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            String annotationName = annotation.annotationType().getName();
            if (!annotationName.startsWith("org.junit.") && !annotationName.startsWith("org.testng.")) continue;
            return true;
        }
        return false;
    }

    private static boolean isJUnit3xTestMethod(@Nonnull Class<?> aClass, @Nonnull Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("test")) {
            return false;
        }
        for (Class<?> superClass = aClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (!"junit.framework.TestCase".equals(superClass.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        Class<?> annotation;
        steCache = new HashMap<StackTraceElement, Boolean>();
        boolean checkOnClassAlso = true;
        try {
            annotation = Class.forName("org.junit.Test");
            checkOnClassAlso = false;
        }
        catch (ClassNotFoundException ignore) {
            annotation = CallPoint.getTestNGAnnotationIfAvailable();
        }
        testAnnotation = annotation;
        checkTestAnnotationOnClass = checkOnClassAlso;
        checkIfTestCaseSubclass = CallPoint.checkForJUnit3Availability();
    }
}

