/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.ListBuilders;

public final class Validations {
    private Validations() {
    }

    public static void validateFieldNamesExist(Class<?> type, List<String> givenFields, Set<String> actualFields) {
        givenFields.forEach(f -> Validations.validate(!actualFields.contains(f), "class " + type.getSimpleName() + " does not contain field " + f + "."));
    }

    public static void validateWarnings(Set<Warning> warnings) {
        Validations.validate(warnings.contains((Object)Warning.SURROGATE_KEY) && warnings.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY), "you can't suppress Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY when Warning.SURROGATE_KEY is also suppressed.");
    }

    public static void validateFields(Set<String> includedFields, Set<String> excludedFields) {
        Validations.validate(!includedFields.isEmpty() && !excludedFields.isEmpty(), "you can call either withOnlyTheseFields or withIgnoredFields, but not both.");
    }

    public static void validateNonnullFields(Set<String> nonnullFields, Set<Warning> warnings) {
        Validations.validate(!nonnullFields.isEmpty() && warnings.contains((Object)Warning.NULL_FIELDS), "you can call either withNonnullFields or suppress Warning.NULL_FIELDS, but not both.");
    }

    public static <T> void validateUnequalExamples(List<T> unequalExamples, List<T> equalExamples) {
        Validations.validate(ListBuilders.listContainsDuplicates(unequalExamples), "two objects are equal to each other.");
        unequalExamples.forEach(u -> Validations.validate(equalExamples.contains(u), "an equal example also appears as unequal example."));
    }

    public static <T> void validateRedAndBlackPrefabValues(Class<T> type, T red, T black) {
        Validations.validateNotNull(type, "type is null.");
        Validations.validateNotNull(red, "red value is null.");
        Validations.validateNotNull(black, "black value is null.");
        Validations.validate(red.equals(black), "both values are equal.");
    }

    public static <T> void validateGenericPrefabValues(Class<T> type, PrefabValueFactory<T> factory, int arity) {
        Validations.validateNotNull(type, "type is null.");
        int n = type.getTypeParameters().length;
        Validations.validate(n != arity, "number of generic type parameters doesn't match:\n  " + type.getName() + " has " + n + "\n  Factory has " + arity);
    }

    public static void validateWarningsAndFields(Set<Warning> warnings, Set<String> includedFields, Set<String> excludedFields) {
        boolean hasSurrogateKey = warnings.contains((Object)Warning.SURROGATE_KEY);
        boolean usesWithOnlyTheseFields = !includedFields.isEmpty();
        boolean usesWithIgnoredFields = !excludedFields.isEmpty();
        Validations.validate(hasSurrogateKey && usesWithOnlyTheseFields, "you can't use withOnlyTheseFields when Warning.SURROGATE_KEY is suppressed.");
        Validations.validate(hasSurrogateKey && usesWithIgnoredFields, "you can't use withIgnoredFields when Warning.SURROGATE_KEY is suppressed.");
    }

    public static void validateGivenAnnotations(Class<?> ... givenAnnotations) {
        Arrays.stream(givenAnnotations).forEach(a -> Validations.validate(!a.isAnnotation(), "class " + a.getCanonicalName() + " is not an annotation."));
    }

    public static void validateProcessedAnnotations(Class<?> type, AnnotationCache cache, Set<Warning> warnings, Set<String> includedFields, Set<String> excludedFields) {
        Validations.validateClassAnnotations(type, cache, warnings, includedFields, excludedFields);
        Validations.validateFieldAnnotations(type, cache, includedFields);
    }

    private static void validateClassAnnotations(Class<?> type, AnnotationCache cache, Set<Warning> warnings, Set<String> includedFields, Set<String> excludedFields) {
        boolean usesWithOnlyTheseFields = !includedFields.isEmpty();
        boolean usesWithIgnoredFields = !excludedFields.isEmpty();
        boolean hasNaturalId = cache.hasClassAnnotation(type, SupportedAnnotations.NATURALID);
        boolean hasSurrogateKey = warnings.contains((Object)Warning.SURROGATE_KEY);
        boolean hasVersionedEntity = warnings.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY);
        Validations.validate(hasNaturalId && usesWithOnlyTheseFields, "you can't use withOnlyTheseFields when fields are marked with @NaturalId.");
        Validations.validate(hasNaturalId && usesWithIgnoredFields, "you can't use withIgnoredFields when fields are marked with @NaturalId.");
        Validations.validate(hasNaturalId && hasSurrogateKey, "you can't suppress Warning.SURROGATE_KEY when fields are marked @NaturalId.");
        Validations.validate(hasNaturalId && hasVersionedEntity, "you can't suppress Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY when fields are marked with @NaturalId.");
    }

    private static void validateFieldAnnotations(Class<?> type, AnnotationCache cache, Set<String> includedFields) {
        FieldIterable.of(type).forEach(f -> Validations.validate(includedFields.contains(f.getName()) && cache.hasFieldAnnotation(type, f.getName(), SupportedAnnotations.ID), "you can't use withOnlyTheseFields on a field marked @Id.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id fields in equals."));
    }

    public static void validateNotNull(Object object, String errormessage) {
        if (object == null) {
            throw new NullPointerException("Precondition: " + errormessage);
        }
    }

    private static void validate(boolean condition, String errorMessage) {
        if (condition) {
            throw new IllegalStateException("Precondition: " + errorMessage);
        }
    }
}

