/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.ByteBuddy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeValidation;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.lib.objenesis.ObjenesisStd;
import nl.jqno.equalsverifier.internal.reflection.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.reflection.Util;

public final class Instantiator<T> {
    private static final List<String> FORBIDDEN_PACKAGES = Arrays.asList("java.", "javax.", "sun.", "com.sun.", "org.w3c.dom.");
    private static final String FALLBACK_PACKAGE_NAME = Instantiator.getPackageName(Instantiator.class);
    private final Class<T> type;
    private Objenesis objenesis;

    private Instantiator(Class<T> type) {
        this.type = type;
        this.objenesis = new ObjenesisStd();
    }

    public static <T> Instantiator<T> of(Class<T> type) {
        if (Modifier.isAbstract(type.getModifiers())) {
            return new Instantiator<T>(Instantiator.giveDynamicSubclass(type));
        }
        return new Instantiator<T>(type);
    }

    public T instantiate() {
        return this.objenesis.newInstance(this.type);
    }

    public T instantiateAnonymousSubclass() {
        Class<T> proxyClass = Instantiator.giveDynamicSubclass(this.type);
        return this.objenesis.newInstance(proxyClass);
    }

    private static synchronized <S> Class<S> giveDynamicSubclass(Class<S> superclass) {
        boolean isSystemClass = Instantiator.isSystemClass(superclass.getName());
        String namePrefix = isSystemClass ? FALLBACK_PACKAGE_NAME : Instantiator.getPackageName(superclass);
        String name = namePrefix + "." + superclass.getSimpleName() + "$$DynamicSubclass$" + superclass.hashCode();
        Class existsAlready = Util.classForName(name);
        if (existsAlready != null) {
            return existsAlready;
        }
        Class context = isSystemClass ? Instantiator.class : superclass;
        ClassLoadingStrategy<ClassLoader> cs = Instantiator.getClassLoadingStrategy(context);
        return new ByteBuddy().with(TypeValidation.DISABLED).subclass(superclass).name(name).make().load(context.getClassLoader(), cs).getLoaded();
    }

    private static String getPackageName(Class<?> type) {
        String cn = type.getName();
        int dot = cn.lastIndexOf(46);
        return dot != -1 ? cn.substring(0, dot).intern() : "";
    }

    public static <S> ClassLoadingStrategy<? super ClassLoader> getClassLoadingStrategy(Class<S> context) {
        if (System.getProperty("java.version").startsWith("1.")) {
            return ClassLoadingStrategy.Default.INJECTION.with(context.getProtectionDomain());
        }
        ConditionalInstantiator ci = new ConditionalInstantiator("java.lang.invoke.MethodHandles$Lookup");
        Object lookup = ci.callFactory("java.lang.invoke.MethodHandles", "privateLookupIn", Util.classes(Class.class, MethodHandles.Lookup.class), Util.objects(context, MethodHandles.lookup()));
        return ClassLoadingStrategy.UsingLookup.of(lookup);
    }

    private static boolean isSystemClass(String className) {
        for (String prefix : FORBIDDEN_PACKAGES) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

