/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;

public class FieldAccessor {
    private final Object object;
    private final Field field;

    public FieldAccessor(Object object, Field field) {
        this.object = object;
        this.field = field;
    }

    public Object getObject() {
        return this.object;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public boolean fieldIsPrimitive() {
        return this.getFieldType().isPrimitive();
    }

    public boolean fieldIsFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean fieldIsStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean fieldIsTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public boolean fieldIsEmptyOrSingleValueEnum() {
        Class<?> type = this.field.getType();
        return type.isEnum() && type.getEnumConstants().length <= 1;
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Only called in test code, not production.")
    public Object get() {
        this.field.setAccessible(true);
        try {
            return this.field.get(this.object);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public void set(Object value) {
        this.modify(() -> this.field.set(this.object, value), true);
    }

    public void defaultField() {
        this.modify(this::setFieldToDefault, false);
    }

    public void defaultStaticField() {
        this.modify(this::setFieldToDefault, true);
    }

    private void setFieldToDefault() throws IllegalAccessException {
        Class<?> type = this.field.getType();
        if (type == Boolean.TYPE) {
            this.field.setBoolean(this.object, false);
        } else if (type == Byte.TYPE) {
            this.field.setByte(this.object, (byte)0);
        } else if (type == Character.TYPE) {
            this.field.setChar(this.object, '\u0000');
        } else if (type == Double.TYPE) {
            this.field.setDouble(this.object, 0.0);
        } else if (type == Float.TYPE) {
            this.field.setFloat(this.object, 0.0f);
        } else if (type == Integer.TYPE) {
            this.field.setInt(this.object, 0);
        } else if (type == Long.TYPE) {
            this.field.setLong(this.object, 0L);
        } else if (type == Short.TYPE) {
            this.field.setShort(this.object, (short)0);
        } else {
            this.field.set(this.object, null);
        }
    }

    public void copyTo(Object to) {
        this.modify(() -> this.field.set(to, this.field.get(this.object)), false);
    }

    public void changeField(PrefabValues prefabValues, TypeTag enclosingType) {
        this.modify(() -> {
            Object newValue = prefabValues.giveOther(TypeTag.of(this.field, enclosingType), this.field.get(this.object));
            this.field.set(this.object, newValue);
        }, false);
    }

    private void modify(FieldModifier modifier, boolean includeStatic) {
        if (!this.canBeModifiedReflectively()) {
            return;
        }
        if (!includeStatic && this.fieldIsStatic()) {
            return;
        }
        this.field.setAccessible(true);
        try {
            modifier.modify();
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public boolean canBeModifiedReflectively() {
        if (this.field.isSynthetic()) {
            return false;
        }
        int modifiers = this.field.getModifiers();
        return !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers);
    }

    @FunctionalInterface
    private static interface FieldModifier {
        public void modify() throws IllegalAccessException;
    }
}

