/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.AbstractGenericFactory;

public class SimpleGenericFactory<T>
extends AbstractGenericFactory<T> {
    private final Func<T> factory;
    private final Supplier<T> emptyFactory;

    public SimpleGenericFactory(Func<T> factory, Supplier<T> emptyFactory) {
        this.factory = factory;
        this.emptyFactory = emptyFactory;
    }

    @Override
    public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
        ArrayList redValues = new ArrayList();
        ArrayList blackValues = new ArrayList();
        boolean useEmpty = false;
        int n = tag.getType().getTypeParameters().length;
        for (int i = 0; i < n; ++i) {
            Object blackValue;
            TypeTag paramTag = this.determineAndCacheActualTypeTag(i, tag, prefabValues, clone);
            Object redValue = prefabValues.giveRed(paramTag);
            if (redValue.equals(blackValue = prefabValues.giveBlack(paramTag))) {
                useEmpty = true;
            }
            redValues.add(redValue);
            blackValues.add(blackValue);
        }
        T red = this.factory.apply(redValues);
        T black = useEmpty && this.emptyFactory != null ? this.emptyFactory.get() : this.factory.apply(blackValues);
        T redCopy = this.factory.apply(redValues);
        return Tuple.of(red, black, redCopy);
    }
}

