/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.AbstractGenericFactory;

public class MapFactory<T extends Map>
extends AbstractGenericFactory<T> {
    private final Supplier<T> createEmpty;

    public MapFactory(Supplier<T> createEmpty) {
        this.createEmpty = createEmpty;
    }

    @Override
    public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
        TypeTag keyTag = this.determineAndCacheActualTypeTag(0, tag, prefabValues, clone);
        TypeTag valueTag = this.determineAndCacheActualTypeTag(1, tag, prefabValues, clone);
        Object redKey = prefabValues.giveRed(keyTag);
        Object blackKey = prefabValues.giveBlack(keyTag);
        Object blackValue = prefabValues.giveBlack(valueTag);
        Map red = (Map)this.createEmpty.get();
        red.put(redKey, blackValue);
        Map black = (Map)this.createEmpty.get();
        if (!redKey.equals(blackKey)) {
            black.put(prefabValues.giveBlack(keyTag), blackValue);
        }
        Map redCopy = (Map)this.createEmpty.get();
        redCopy.put(redKey, blackValue);
        return new Tuple<Map>(red, black, redCopy);
    }
}

