/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.util.LinkedHashSet;
import java.util.function.Function;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.AbstractGenericFactory;

public class CopyFactory<T, S>
extends AbstractGenericFactory<T> {
    private final Class<S> source;
    private Function<S, T> copy;

    public CopyFactory(Class<S> source, Function<S, T> copy) {
        this.source = source;
        this.copy = copy;
    }

    @Override
    public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
        TypeTag sourceTag = this.copyGenericTypesInto(this.source, tag);
        prefabValues.realizeCacheFor(sourceTag, clone);
        Object redSource = prefabValues.giveRed(sourceTag);
        Object blackSource = prefabValues.giveBlack(sourceTag);
        Object redCopySource = prefabValues.giveRedCopy(sourceTag);
        return Tuple.of(this.copy.apply(redSource), this.copy.apply(blackSource), this.copy.apply(redCopySource));
    }
}

