/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class TransitivityFieldCheck
implements FieldCheck {
    private final PrefabValues prefabValues;
    private final TypeTag typeTag;

    public TransitivityFieldCheck(PrefabValues prefabValues, TypeTag typeTag) {
        this.prefabValues = prefabValues;
        this.typeTag = typeTag;
    }

    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        Object a1 = referenceAccessor.getObject();
        Object b1 = this.buildB1(changedAccessor);
        Object b2 = this.buildB2(a1, referenceAccessor.getField());
        boolean x = a1.equals(b1);
        boolean y = b1.equals(b2);
        boolean z = a1.equals(b2);
        if (this.countFalses(x, y, z) == 1) {
            Assert.fail(Formatter.of("Transitivity: two of these three instances are equal to each other, so the third one should be, too:\n-  %%\n-  %%\n-  %%", a1, b1, b2));
        }
    }

    private Object buildB1(FieldAccessor accessor) {
        accessor.changeField(this.prefabValues, this.typeTag);
        return accessor.getObject();
    }

    private Object buildB2(Object a1, Field referenceField) {
        Object result = ObjectAccessor.of(a1).copy();
        ObjectAccessor<Object> objectAccessor = ObjectAccessor.of(result);
        objectAccessor.fieldAccessorFor(referenceField).changeField(this.prefabValues, this.typeTag);
        for (Field field : FieldIterable.of(result.getClass())) {
            if (field.equals(referenceField)) continue;
            objectAccessor.fieldAccessorFor(field).changeField(this.prefabValues, this.typeTag);
        }
        return result;
    }

    private int countFalses(boolean ... bools) {
        int result = 0;
        for (boolean b : bools) {
            if (b) continue;
            ++result;
        }
        return result;
    }
}

