/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class TransientFieldsCheck<T>
implements FieldCheck {
    private final PrefabValues prefabValues;
    private final TypeTag typeTag;
    private final AnnotationCache annotationCache;

    public TransientFieldsCheck(Configuration<T> config) {
        this.prefabValues = config.getPrefabValues();
        this.typeTag = config.getTypeTag();
        this.annotationCache = config.getAnnotationCache();
    }

    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        boolean fieldIsTransient;
        Object reference = referenceAccessor.getObject();
        Object changed = changedAccessor.getObject();
        changedAccessor.changeField(this.prefabValues, this.typeTag);
        boolean equalsChanged = !reference.equals(changed);
        boolean bl = fieldIsTransient = referenceAccessor.fieldIsTransient() || this.annotationCache.hasFieldAnnotation(this.typeTag.getType(), referenceAccessor.getFieldName(), SupportedAnnotations.TRANSIENT);
        if (equalsChanged && fieldIsTransient) {
            Assert.fail(Formatter.of("Transient field %% should not be included in equals/hashCode contract.", referenceAccessor.getFieldName()));
        }
        referenceAccessor.changeField(this.prefabValues, this.typeTag);
    }
}

