/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class SignificantFieldCheck<T>
implements FieldCheck {
    private final Class<?> type;
    private final TypeTag typeTag;
    private final PrefabValues prefabValues;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> ignoredFields;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final AnnotationCache annotationCache;
    private final Predicate<FieldAccessor> isCachedHashCodeField;
    private final boolean skipCertainTestsThatDontMatterWhenValuesAreNull;

    public SignificantFieldCheck(Configuration<T> config, Predicate<FieldAccessor> isCachedHashCodeField, boolean skipCertainTestsThatDontMatterWhenValuesAreNull) {
        this.type = config.getType();
        this.typeTag = config.getTypeTag();
        this.prefabValues = config.getPrefabValues();
        this.warningsToSuppress = config.getWarningsToSuppress();
        this.ignoredFields = config.getIgnoredFields();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
        this.annotationCache = config.getAnnotationCache();
        this.isCachedHashCodeField = isCachedHashCodeField;
        this.skipCertainTestsThatDontMatterWhenValuesAreNull = skipCertainTestsThatDontMatterWhenValuesAreNull;
    }

    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        if (this.isCachedHashCodeField.test(referenceAccessor)) {
            return;
        }
        Object reference = referenceAccessor.getObject();
        Object changed = changedAccessor.getObject();
        String fieldName = referenceAccessor.getFieldName();
        boolean equalToItself = reference.equals(changed);
        changedAccessor.changeField(this.prefabValues, this.typeTag);
        boolean equalsChanged = !reference.equals(changed);
        boolean hashCodeChanged = this.cachedHashCodeInitializer.getInitializedHashCode(reference) != this.cachedHashCodeInitializer.getInitializedHashCode(changed);
        this.assertEqualsAndHashCodeRelyOnSameFields(equalsChanged, hashCodeChanged, reference, changed, fieldName);
        this.assertFieldShouldBeIgnored(equalToItself, equalsChanged, referenceAccessor, fieldName);
        referenceAccessor.changeField(this.prefabValues, this.typeTag);
    }

    private void assertEqualsAndHashCodeRelyOnSameFields(boolean equalsChanged, boolean hashCodeChanged, Object reference, Object changed, String fieldName) {
        if (equalsChanged != hashCodeChanged) {
            Formatter formatter;
            boolean skipEqualsHasMoreThanHashCodeTest;
            boolean bl = skipEqualsHasMoreThanHashCodeTest = this.warningsToSuppress.contains((Object)Warning.STRICT_HASHCODE) || this.skipCertainTestsThatDontMatterWhenValuesAreNull;
            if (!skipEqualsHasMoreThanHashCodeTest) {
                formatter = Formatter.of("Significant fields: equals relies on %%, but hashCode does not.\n  %% has hashCode %%\n  %% has hashCode %%", fieldName, reference, reference.hashCode(), changed, changed.hashCode());
                Assert.assertFalse(formatter, equalsChanged);
            }
            formatter = Formatter.of("Significant fields: hashCode relies on %%, but equals does not.\nThese objects are equal, but probably shouldn't be:\n  %%\nand\n  %%", fieldName, reference, changed);
            Assert.assertFalse(formatter, hashCodeChanged);
        }
    }

    private void assertFieldShouldBeIgnored(boolean equalToItself, boolean equalsChanged, FieldAccessor referenceAccessor, String fieldName) {
        if (this.shouldAllFieldsBeUsed(referenceAccessor) && this.isFieldEligible(referenceAccessor)) {
            boolean fieldShouldBeIgnored = this.ignoredFields.contains(fieldName);
            boolean thisFieldIsMarkedAsId = this.annotationCache.hasFieldAnnotation(this.type, fieldName, SupportedAnnotations.ID);
            boolean anotherFieldIsMarkedAsId = !thisFieldIsMarkedAsId && this.annotationCache.hasClassAnnotation(this.type, SupportedAnnotations.ID);
            Assert.assertTrue(Formatter.of("Significant fields: equals does not use %%.", fieldName), equalToItself);
            this.assertFieldShouldHaveBeenUsed(fieldName, equalsChanged, fieldShouldBeIgnored, thisFieldIsMarkedAsId, anotherFieldIsMarkedAsId);
            this.assertFieldShouldNotBeUsed(fieldName, equalsChanged, fieldShouldBeIgnored, thisFieldIsMarkedAsId, anotherFieldIsMarkedAsId);
        }
    }

    private boolean shouldAllFieldsBeUsed(FieldAccessor referenceAccessor) {
        return !this.warningsToSuppress.contains((Object)Warning.ALL_FIELDS_SHOULD_BE_USED) && !this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY) && (!this.warningsToSuppress.contains((Object)Warning.ALL_NONFINAL_FIELDS_SHOULD_BE_USED) || referenceAccessor.fieldIsFinal());
    }

    private boolean isFieldEligible(FieldAccessor referenceAccessor) {
        return !referenceAccessor.fieldIsStatic() && !referenceAccessor.fieldIsTransient() && !referenceAccessor.fieldIsEmptyOrSingleValueEnum() && !this.annotationCache.hasFieldAnnotation(this.type, referenceAccessor.getField().getName(), SupportedAnnotations.TRANSIENT);
    }

    private void assertFieldShouldHaveBeenUsed(String fieldName, boolean equalsChanged, boolean fieldShouldBeIgnored, boolean thisFieldIsMarkedAsId, boolean anotherFieldIsMarkedAsId) {
        String message = thisFieldIsMarkedAsId ? "Significant fields: %% is marked @Id and Warning.SURROGATE_KEY is suppressed, but equals does not use it." : (anotherFieldIsMarkedAsId ? "Significant fields: equals does not use %%, or it is stateless.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id field(s)." : "Significant fields: equals does not use %%, or it is stateless.");
        Assert.assertTrue(Formatter.of(message, fieldName), fieldShouldBeIgnored || equalsChanged);
    }

    private void assertFieldShouldNotBeUsed(String fieldName, boolean equalsChanged, boolean fieldShouldBeIgnored, boolean thisFieldIsMarkedAsId, boolean anotherFieldIsMarkedAsId) {
        String message = thisFieldIsMarkedAsId ? "Significant fields: %% is marked @Id so equals should not use it, but it does.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id field(s)." : (anotherFieldIsMarkedAsId ? "Significant fields: equals should not use %% because Warning.SURROGATE_KEY is suppressed and it is not marked as @Id, but it does." : "Significant fields: equals should not use %%, but it does.");
        Assert.assertTrue(Formatter.of(message, fieldName), !fieldShouldBeIgnored || !equalsChanged || this.skipCertainTestsThatDontMatterWhenValuesAreNull);
    }
}

