/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Set;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class ReflexivityFieldCheck<T>
implements FieldCheck {
    private final TypeTag typeTag;
    private final PrefabValues prefabValues;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> nonnullFields;
    private final AnnotationCache annotationCache;

    public ReflexivityFieldCheck(Configuration<T> config) {
        this.typeTag = config.getTypeTag();
        this.prefabValues = config.getPrefabValues();
        this.warningsToSuppress = config.getWarningsToSuppress();
        this.nonnullFields = config.getNonnullFields();
        this.annotationCache = config.getAnnotationCache();
    }

    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        if (this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY)) {
            return;
        }
        this.checkReferenceReflexivity(referenceAccessor, changedAccessor);
        this.checkValueReflexivity(referenceAccessor, changedAccessor);
        this.checkNullReflexivity(referenceAccessor, changedAccessor);
    }

    private void checkReferenceReflexivity(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        this.checkReflexivityFor(referenceAccessor, changedAccessor);
    }

    private void checkValueReflexivity(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        Class<?> fieldType = changedAccessor.getFieldType();
        if (this.warningsToSuppress.contains((Object)Warning.REFERENCE_EQUALITY)) {
            return;
        }
        if (fieldType.equals(Object.class) || fieldType.isInterface()) {
            return;
        }
        if (changedAccessor.fieldIsStatic()) {
            return;
        }
        ClassAccessor<?> fieldTypeAccessor = ClassAccessor.of(fieldType, this.prefabValues);
        if (!fieldTypeAccessor.declaresEquals()) {
            return;
        }
        Object value = changedAccessor.get();
        if (value.getClass().isSynthetic()) {
            return;
        }
        TypeTag tag = TypeTag.of(referenceAccessor.getField(), this.typeTag);
        referenceAccessor.set(this.prefabValues.giveRed(tag));
        changedAccessor.set(this.prefabValues.giveRedCopy(tag));
        Formatter f = Formatter.of("Reflexivity: == used instead of .equals() on field: %%\nIf this is intentional, consider suppressing Warning.%%", changedAccessor.getFieldName(), Warning.REFERENCE_EQUALITY.toString());
        Object left = referenceAccessor.getObject();
        Object right = changedAccessor.getObject();
        Assert.assertEquals(f, left, right);
    }

    private void checkNullReflexivity(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        boolean ignoreNull;
        Field field = referenceAccessor.getField();
        boolean fieldIsPrimitive = referenceAccessor.fieldIsPrimitive();
        boolean fieldIsNonNull = NonnullAnnotationVerifier.fieldIsNonnull(field, this.annotationCache);
        boolean bl = ignoreNull = fieldIsNonNull || this.warningsToSuppress.contains((Object)Warning.NULL_FIELDS) || this.nonnullFields.contains(field.getName());
        if (fieldIsPrimitive || !ignoreNull) {
            referenceAccessor.defaultField();
            changedAccessor.defaultField();
            this.checkReflexivityFor(referenceAccessor, changedAccessor);
        }
    }

    private void checkReflexivityFor(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        Object left = referenceAccessor.getObject();
        Object right = changedAccessor.getObject();
        if (this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY)) {
            Assert.assertFalse(Formatter.of("Unnecessary suppression: %%. Two identical copies are equal.", Warning.IDENTICAL_COPY.toString()), left.equals(right));
        } else {
            Formatter f = Formatter.of("Reflexivity: object does not equal an identical copy of itself:\n  %%\nIf this is intentional, consider suppressing Warning.%%", left, Warning.IDENTICAL_COPY.toString());
            Assert.assertEquals(f, left, right);
        }
    }
}

