/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We only want to see if it throws an exception.")
public class NullPointerExceptionFieldCheck<T>
implements FieldCheck {
    private Configuration<T> config;

    public NullPointerExceptionFieldCheck(Configuration<T> config) {
        this.config = config;
    }

    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        Field field = referenceAccessor.getField();
        if (this.config.getNonnullFields().contains(field.getName())) {
            return;
        }
        if (field.getType().isPrimitive()) {
            return;
        }
        if (NonnullAnnotationVerifier.fieldIsNonnull(field, this.config.getAnnotationCache())) {
            return;
        }
        if (referenceAccessor.fieldIsStatic()) {
            Object saved = referenceAccessor.get();
            referenceAccessor.defaultStaticField();
            this.performTests(field, referenceAccessor.getObject(), changedAccessor.getObject());
            referenceAccessor.set(saved);
        } else {
            changedAccessor.defaultField();
            this.performTests(field, referenceAccessor.getObject(), changedAccessor.getObject());
            referenceAccessor.defaultField();
        }
    }

    private void performTests(Field field, Object reference, Object changed) {
        this.handle("equals", field, () -> reference.equals(changed));
        this.handle("equals", field, () -> changed.equals(reference));
        this.handle("hashCode", field, () -> this.config.getCachedHashCodeInitializer().getInitializedHashCode(changed));
    }

    private void handle(String testedMethodName, Field field, Runnable r) {
        try {
            r.run();
        }
        catch (NullPointerException e) {
            this.npeThrown(testedMethodName, field, e);
        }
        catch (AbstractMethodError e) {
            this.abstractMethodErrorThrown(testedMethodName, field, e);
        }
        catch (ClassCastException e) {
            this.classCastExceptionThrown(field, e);
        }
        catch (Exception e) {
            this.exceptionThrown(testedMethodName, field, e);
        }
    }

    private void npeThrown(String method, Field field, NullPointerException e) {
        Assert.fail(Formatter.of("Non-nullity: %% throws NullPointerException on field %%.", method, field.getName()), e);
    }

    private void abstractMethodErrorThrown(String method, Field field, AbstractMethodError e) {
        Assert.fail(Formatter.of("Abstract delegation: %% throws AbstractMethodError when field %% is null.\nSuppress Warning.NULL_FIELDS to disable this check.", method, field.getName()), e);
    }

    private void classCastExceptionThrown(Field field, ClassCastException e) {
        Assert.fail(Formatter.of("Generics: ClassCastException was thrown. Consider using withGenericPrefabValues for %%.", field.getType().getSimpleName()), e);
    }

    private void exceptionThrown(String method, Field field, Exception e) {
        Assert.fail(Formatter.of("%% throws %% when field %% is null.", method, e.getClass().getSimpleName(), field.getName()), e);
    }
}

