/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.util.function.Predicate;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class MutableStateFieldCheck
implements FieldCheck {
    private final PrefabValues prefabValues;
    private final TypeTag typeTag;
    private final Predicate<FieldAccessor> isCachedHashCodeField;

    public MutableStateFieldCheck(PrefabValues prefabValues, TypeTag typeTag, Predicate<FieldAccessor> isCachedHashCodeField) {
        this.prefabValues = prefabValues;
        this.typeTag = typeTag;
        this.isCachedHashCodeField = isCachedHashCodeField;
    }

    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        boolean equalsChanged;
        if (this.isCachedHashCodeField.test(referenceAccessor)) {
            return;
        }
        Object reference = referenceAccessor.getObject();
        Object changed = changedAccessor.getObject();
        changedAccessor.changeField(this.prefabValues, this.typeTag);
        boolean bl = equalsChanged = !reference.equals(changed);
        if (equalsChanged && !referenceAccessor.fieldIsFinal()) {
            Assert.fail(Formatter.of("Mutability: equals depends on mutable field %%.", referenceAccessor.getFieldName()));
        }
        referenceAccessor.changeField(this.prefabValues, this.typeTag);
    }
}

