/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifierReport;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.AbstractDelegationChecker;
import nl.jqno.equalsverifier.internal.checkers.CachedHashCodeChecker;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.checkers.ExamplesChecker;
import nl.jqno.equalsverifier.internal.checkers.FieldsChecker;
import nl.jqno.equalsverifier.internal.checkers.HierarchyChecker;
import nl.jqno.equalsverifier.internal.checkers.NullChecker;
import nl.jqno.equalsverifier.internal.checkers.SignatureChecker;
import nl.jqno.equalsverifier.internal.exceptions.MessagingException;
import nl.jqno.equalsverifier.internal.prefabvalues.FactoryCache;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.FieldNameExtractor;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.PrefabValuesApi;
import nl.jqno.equalsverifier.internal.util.Validations;

public class EqualsVerifierApi<T> {
    private final Class<T> type;
    private final Set<String> actualFields;
    private EnumSet<Warning> warningsToSuppress = EnumSet.noneOf(Warning.class);
    private boolean usingGetClass = false;
    private boolean hasRedefinedSuperclass = false;
    private Class<? extends T> redefinedSubclass = null;
    private FactoryCache factoryCache = new FactoryCache();
    private CachedHashCodeInitializer<T> cachedHashCodeInitializer = CachedHashCodeInitializer.passthrough();
    private Set<String> allExcludedFields = new HashSet<String>();
    private Set<String> allIncludedFields = new HashSet<String>();
    private Set<String> nonnullFields = new HashSet<String>();
    private Set<String> ignoredAnnotationClassNames = new HashSet<String>();
    private List<T> equalExamples = new ArrayList<T>();
    private List<T> unequalExamples = new ArrayList<T>();

    EqualsVerifierApi(Class<T> type) {
        this.type = type;
        this.actualFields = FieldNameExtractor.extractFieldNames(type);
    }

    EqualsVerifierApi(Class<T> type, EnumSet<Warning> warningsToSuppress, FactoryCache factoryCache, boolean usingGetClass) {
        this(type);
        this.warningsToSuppress = warningsToSuppress;
        this.factoryCache = this.factoryCache.merge(factoryCache);
        this.usingGetClass = usingGetClass;
    }

    EqualsVerifierApi(Class<T> type, List<T> equalExamples, List<T> unequalExamples) {
        this(type);
        this.equalExamples = equalExamples;
        this.unequalExamples = unequalExamples;
    }

    public EqualsVerifierApi<T> suppress(Warning ... warnings) {
        Collections.addAll(this.warningsToSuppress, warnings);
        Validations.validateWarnings(this.warningsToSuppress);
        Validations.validateWarningsAndFields(this.warningsToSuppress, this.allIncludedFields, this.allExcludedFields);
        Validations.validateNonnullFields(this.nonnullFields, this.warningsToSuppress);
        return this;
    }

    public <S> EqualsVerifierApi<T> withPrefabValues(Class<S> otherType, S red, S black) {
        PrefabValuesApi.addPrefabValues(this.factoryCache, otherType, red, black);
        return this;
    }

    public <S> EqualsVerifierApi<T> withGenericPrefabValues(Class<S> otherType, Func.Func1<?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    public <S> EqualsVerifierApi<T> withGenericPrefabValues(Class<S> otherType, Func.Func2<?, ?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    public EqualsVerifierApi<T> usingGetClass() {
        this.usingGetClass = true;
        return this;
    }

    public EqualsVerifierApi<T> withIgnoredFields(String ... fields) {
        return this.withFieldsAddedAndValidated(this.allExcludedFields, Arrays.asList(fields));
    }

    public EqualsVerifierApi<T> withOnlyTheseFields(String ... fields) {
        return this.withFieldsAddedAndValidated(this.allIncludedFields, Arrays.asList(fields));
    }

    private EqualsVerifierApi<T> withFieldsAddedAndValidated(Set<String> collection, List<String> specifiedFields) {
        collection.addAll(specifiedFields);
        Validations.validateFields(this.allIncludedFields, this.allExcludedFields);
        Validations.validateFieldNamesExist(this.type, specifiedFields, this.actualFields);
        Validations.validateWarningsAndFields(this.warningsToSuppress, this.allIncludedFields, this.allExcludedFields);
        return this;
    }

    public EqualsVerifierApi<T> withNonnullFields(String ... fields) {
        List<String> fieldsAsList = Arrays.asList(fields);
        this.nonnullFields.addAll(fieldsAsList);
        Validations.validateFieldNamesExist(this.type, fieldsAsList, this.actualFields);
        Validations.validateNonnullFields(this.nonnullFields, this.warningsToSuppress);
        return this;
    }

    public EqualsVerifierApi<T> withIgnoredAnnotations(Class<?> ... annotations) {
        Validations.validateGivenAnnotations(annotations);
        for (Class<?> ignoredAnnotation : annotations) {
            this.ignoredAnnotationClassNames.add(ignoredAnnotation.getCanonicalName());
        }
        return this;
    }

    public EqualsVerifierApi<T> withRedefinedSuperclass() {
        this.hasRedefinedSuperclass = true;
        return this;
    }

    public EqualsVerifierApi<T> withRedefinedSubclass(Class<? extends T> subclass) {
        this.redefinedSubclass = subclass;
        return this;
    }

    public EqualsVerifierApi<T> withCachedHashCode(String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        this.cachedHashCodeInitializer = new CachedHashCodeInitializer<T>(this.type, cachedHashCodeField, calculateHashCodeMethod, example);
        return this;
    }

    public void verify() {
        try {
            this.performVerification();
        }
        catch (MessagingException e) {
            throw new AssertionError(this.buildErrorMessage(e.getDescription()), e);
        }
        catch (Throwable e) {
            throw new AssertionError(this.buildErrorMessage(e.getMessage()), e);
        }
    }

    public EqualsVerifierReport report() {
        try {
            this.performVerification();
            return EqualsVerifierReport.SUCCESS;
        }
        catch (MessagingException e) {
            return new EqualsVerifierReport(false, this.buildErrorMessage(e.getDescription()), e);
        }
        catch (Throwable e) {
            return new EqualsVerifierReport(false, this.buildErrorMessage(e.getMessage()), e);
        }
    }

    private String buildErrorMessage(String description) {
        return Formatter.of("EqualsVerifier found a problem in class %%.\n-> %%\n\nFor more information, go to: http://www.jqno.nl/equalsverifier/errormessages", this.type.getSimpleName(), description).format();
    }

    private void performVerification() {
        if (this.type.isEnum()) {
            return;
        }
        Configuration<T> config = this.buildConfig();
        Validations.validateProcessedAnnotations(this.type, config.getAnnotationCache(), this.warningsToSuppress, this.allIncludedFields, this.allExcludedFields);
        this.verifyWithoutExamples(config);
        this.verifyWithExamples(config);
    }

    private Configuration<T> buildConfig() {
        return Configuration.build(this.type, this.allExcludedFields, this.allIncludedFields, this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress, this.factoryCache, this.ignoredAnnotationClassNames, this.actualFields, this.equalExamples, this.unequalExamples);
    }

    private void verifyWithoutExamples(Configuration<T> config) {
        Checker[] checkers;
        for (Checker checker : checkers = new Checker[]{new SignatureChecker<T>(config), new AbstractDelegationChecker<T>(config), new NullChecker<T>(config), new CachedHashCodeChecker<T>(config)}) {
            checker.check();
        }
    }

    private void verifyWithExamples(Configuration<T> config) {
        Checker[] checkers;
        for (Checker checker : checkers = new Checker[]{new ExamplesChecker<T>(config), new HierarchyChecker<T>(config), new FieldsChecker<T>(config)}) {
            checker.check();
        }
    }
}

