/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.Collections;
import java.util.EnumSet;
import nl.jqno.equalsverifier.EqualsVerifierApi;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.prefabvalues.FactoryCache;
import nl.jqno.equalsverifier.internal.util.PrefabValuesApi;

public final class ConfiguredEqualsVerifier {
    private final EnumSet<Warning> warningsToSuppress = EnumSet.noneOf(Warning.class);
    private final FactoryCache factoryCache = new FactoryCache();
    private boolean usingGetClass = false;

    public ConfiguredEqualsVerifier suppress(Warning ... warnings) {
        Collections.addAll(this.warningsToSuppress, warnings);
        return this;
    }

    public <S> ConfiguredEqualsVerifier withPrefabValues(Class<S> otherType, S red, S black) {
        PrefabValuesApi.addPrefabValues(this.factoryCache, otherType, red, black);
        return this;
    }

    public <S> ConfiguredEqualsVerifier withGenericPrefabValues(Class<S> otherType, Func.Func1<?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    public <S> ConfiguredEqualsVerifier withGenericPrefabValues(Class<S> otherType, Func.Func2<?, ?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    public ConfiguredEqualsVerifier usingGetClass() {
        this.usingGetClass = true;
        return this;
    }

    public <T> EqualsVerifierApi<T> forClass(Class<T> type) {
        return new EqualsVerifierApi<T>(type, EnumSet.copyOf(this.warningsToSuppress), this.factoryCache, this.usingGetClass);
    }
}

