/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionCache {
    private HashMap<String, ArrayList<String>> cache = new HashMap();

    protected void cacheKey(String key) {
        if (this.cache.containsKey(key)) {
            return;
        }
        this.cache.put(key, new ArrayList());
    }

    protected void cacheValue(String key, String value) {
        this.cacheKey(key);
        ArrayList<String> values = this.cache.get(key);
        if (!values.contains(value)) {
            values.add(value);
        }
    }

    protected void cachePrimitive(OsmPrimitive primitive) {
        for (String key : primitive.keySet()) {
            String value = primitive.get(key);
            this.cacheValue(key, value);
        }
    }

    public void initFromJOSMDataset() {
        this.cache = new HashMap();
        Collection ds = Main.ds.allNonDeletedPrimitives();
        for (OsmPrimitive primitive : ds) {
            this.cachePrimitive(primitive);
        }
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.cache.keySet());
    }

    public List<String> getValues(String key) {
        if (!this.cache.containsKey(key)) {
            return new ArrayList<String>();
        }
        return this.cache.get(key);
    }
}

