/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.tagspec.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.plugins.tageditor.tagspec.TagSpecifications;

public class TagsTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(TagsTableModel.class.getName());
    private ArrayList<KeyValuePair> items = new ArrayList();
    private ArrayList<KeyValuePair> visibleItems = new ArrayList();

    protected void sort() {
        Collections.sort(this.items, new Comparator<KeyValuePair>(){

            @Override
            public int compare(KeyValuePair self, KeyValuePair other) {
                int ret = self.getKey().compareToIgnoreCase(other.getKey());
                if (ret == 0) {
                    return self.getValue().compareToIgnoreCase(other.getValue());
                }
                return ret;
            }
        });
    }

    protected void clear() {
        this.items.clear();
        this.visibleItems.clear();
    }

    public void initFromTagSpecifications() {
        TagSpecifications spec;
        this.clear();
        try {
            spec = TagSpecifications.getInstance();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to init TagTableModel. Exception:" + e);
            return;
        }
        this.items = spec.asList();
        this.sort();
        for (KeyValuePair item : this.items) {
            this.visibleItems.add(item);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.visibleItems.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        KeyValuePair pair = this.visibleItems.get(row);
        switch (col) {
            case 0: {
                return pair.getKey();
            }
            case 1: {
                return pair.getValue();
            }
        }
        throw new IllegalArgumentException("unexpected column number " + col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(String filter) {
        TagsTableModel tagsTableModel = this;
        synchronized (tagsTableModel) {
            if (filter == null || filter.trim().equals("")) {
                this.visibleItems.clear();
                for (KeyValuePair pair : this.items) {
                    this.visibleItems.add(pair);
                }
            } else {
                this.visibleItems.clear();
                filter = filter.toLowerCase();
                for (KeyValuePair pair : this.items) {
                    if (!pair.getKey().toLowerCase().trim().startsWith(filter) && !pair.getValue().toLowerCase().trim().startsWith(filter)) continue;
                    this.visibleItems.add(pair);
                }
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public KeyValuePair getVisibleItem(int row) {
        if (row < 0 || row >= this.visibleItems.size()) {
            throw new IndexOutOfBoundsException("row is out of bound: row=" + row);
        }
        return this.visibleItems.get(row);
    }
}

