/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.Presets;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.IPresetSelectorListener;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.PresetsTable;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.PresetsTableColumnModel;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.PresetsTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TabularPresetSelector
extends JPanel {
    private PresetsTable presetsTable = null;
    private JTextField tfFilter = null;
    private ArrayList<IPresetSelectorListener> listeners = new ArrayList();
    private JScrollPane scrollPane;
    private JButton btnApply;

    protected JPanel buildFilterPanel() {
        JPanel pnl = new JPanel();
        JLabel lbl = new JLabel(I18n.tr((String)"Search: "));
        pnl.setLayout(new FlowLayout(0));
        this.tfFilter = new JTextField(20);
        pnl.add(lbl);
        pnl.add((Component)this.tfFilter, "Center");
        JButton btn = new JButton(I18n.tr((String)"Filter"));
        pnl.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularPresetSelector.this.filter(TabularPresetSelector.this.tfFilter.getText());
            }
        });
        btn = new JButton(I18n.tr((String)"Clear"));
        pnl.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularPresetSelector.this.tfFilter.setText("");
                TabularPresetSelector.this.tfFilter.requestFocus();
            }
        });
        return pnl;
    }

    protected JScrollPane buildPresetGrid() {
        this.presetsTable = new PresetsTable(new PresetsTableModel(), new PresetsTableColumnModel());
        this.scrollPane = new JScrollPane(this.presetsTable);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Dimension d = TabularPresetSelector.this.scrollPane.getViewport().getExtentSize();
                TabularPresetSelector.this.presetsTable.adjustColumnWidth(d.width);
            }
        });
        this.presetsTable.addMouseListener(new DoubleClickAdapter());
        this.presetsTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ActionListener enterAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowNum = TabularPresetSelector.this.presetsTable.getSelectedRow();
                if (rowNum >= 0) {
                    Item item = TabularPresetSelector.this.getModel().getVisibleItem(rowNum);
                    TabularPresetSelector.this.fireItemSelected(item);
                }
            }
        };
        this.presetsTable.registerKeyboardAction(enterAction, "Enter", KeyStroke.getKeyStroke(10, 0), 0);
        return this.scrollPane;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        this.btnApply = new JButton("Apply");
        pnl.add(this.btnApply);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = TabularPresetSelector.this.presetsTable.getSelectedRow();
                if (row >= 0) {
                    Item item = TabularPresetSelector.this.getModel().getVisibleItem(row);
                    TabularPresetSelector.this.fireItemSelected(item);
                }
            }
        });
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildFilterPanel(), "North");
        this.add((Component)this.buildPresetGrid(), "Center");
        this.add((Component)this.buildControlButtonPanel(), "South");
        this.tfFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                this.onUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.onUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.onUpdate();
            }

            protected void onUpdate() {
                TabularPresetSelector.this.filter(TabularPresetSelector.this.tfFilter.getText());
            }
        });
        this.tfFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularPresetSelector.this.filter(TabularPresetSelector.this.tfFilter.getText());
            }
        });
        this.presetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TabularPresetSelector.this.btnApply.setEnabled(TabularPresetSelector.this.presetsTable.getSelectedRowCount() != 0);
            }
        });
        Presets.initPresets();
        this.bindTo(Presets.getPresets());
        this.presetsTable.getSelectionModel().clearSelection();
        this.btnApply.setEnabled(false);
    }

    public void bindTo(Presets presets) {
        PresetsTableModel model = (PresetsTableModel)this.presetsTable.getModel();
        model.setPresets(presets);
    }

    public TabularPresetSelector() {
        this.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPresetSelectorListener(IPresetSelectorListener listener) {
        ArrayList<IPresetSelectorListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresetSelectorListener(IPresetSelectorListener listener) {
        ArrayList<IPresetSelectorListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemSelected(Item item) {
        ArrayList<IPresetSelectorListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (IPresetSelectorListener listener : this.listeners) {
                listener.itemSelected(item);
            }
        }
    }

    public void filter(String filter) {
        this.presetsTable.getSelectionModel().clearSelection();
        this.getModel().filter(filter);
        this.presetsTable.scrollRectToVisible(this.presetsTable.getCellRect(0, 0, false));
        for (Container c = this.presetsTable; c != null; c = c.getParent()) {
            ((Component)c).doLayout();
            c.repaint();
        }
    }

    protected PresetsTableModel getModel() {
        return (PresetsTableModel)this.presetsTable.getModel();
    }

    public void installKeyAction(Action a) {
        this.getInputMap(2).put((KeyStroke)a.getValue("AcceleratorKey"), a.getValue("Name"));
        this.getActionMap().put(a.getValue("Name"), a);
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int rowNum = TabularPresetSelector.this.presetsTable.rowAtPoint(e.getPoint());
                Item item = TabularPresetSelector.this.getModel().getVisibleItem(rowNum);
                TabularPresetSelector.this.fireItemSelected(item);
            }
        }
    }
}

