/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.tageditor.preset.INameIconProvider;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.util.IndentWriter;

public class Group
implements INameIconProvider {
    private static Logger logger = Logger.getLogger(Group.class.getName());
    private String name;
    private String iconName;
    private ImageIcon icon;
    private List<Item> items = new ArrayList<Item>();

    public Group() {
    }

    public Group(String name) {
        this();
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            URL url = Main.class.getResource("/images/" + this.getIconName());
            if (url == null) {
                logger.warning("failed to create URL for resource 'images/" + this.getIconName() + "'");
                this.icon = null;
            } else {
                this.icon = new ImageIcon(url);
                Image i = this.icon.getImage().getScaledInstance(16, 16, 1);
                this.icon = new ImageIcon(i);
            }
        }
        return this.icon;
    }

    public void addItem(Item item) {
        item.setParent(this);
        this.items.add(item);
    }

    public void removeItem(Item item) {
        this.items.remove(item);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void dump(IndentWriter writer) throws IOException {
        writer.indent();
        writer.write("<group ");
        writer.write(String.format("name=\"%s\" ", this.name));
        writer.write(String.format("iconName=\"%s\" ", this.iconName));
        writer.write(">");
        writer.write("\n");
        writer.incLevel();
        for (Item item : this.items) {
            item.dump(writer);
        }
        writer.decLevel();
        writer.writeLine("</group>");
    }
}

