/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionCache;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.tageditor.ac.IAutoCompletionListListener;
import org.openstreetmap.josm.plugins.tageditor.editor.PresetManager;
import org.openstreetmap.josm.plugins.tageditor.editor.RunnableAction;
import org.openstreetmap.josm.plugins.tageditor.editor.TableCellEditor;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.editor.TagTable;

public class TagEditor
extends JPanel
implements IAutoCompletionListListener {
    private static final Logger logger = Logger.getLogger(TagEditor.class.getName());
    private TagEditorModel tagEditorModel = new TagEditorModel();
    private TagTable tblTagEditor;
    private PresetManager presetManager;
    private AutoCompletionList autoCompletionList;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.tblTagEditor = new TagTable(this.tagEditorModel);
        final JScrollPane scrollPane = new JScrollPane(this.tblTagEditor);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane, "Center");
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Dimension d = scrollPane.getViewport().getExtentSize();
                TagEditor.this.tblTagEditor.adjustColumnWidth(d.width);
            }
        });
        this.presetManager = new PresetManager();
        this.presetManager.setModel(this.tagEditorModel);
        this.add((Component)this.presetManager, "North");
    }

    public TagEditor() {
        this.build();
    }

    public TagEditorModel getTagEditorModel() {
        return this.tagEditorModel;
    }

    public void setTagEditorModel(TagEditorModel tagEditorModel) {
        this.tblTagEditor.setModel(tagEditorModel);
        this.presetManager.setModel(tagEditorModel);
    }

    public RunnableAction getDeleteAction() {
        return this.tblTagEditor.getDeleteAction();
    }

    public RunnableAction getAddAction() {
        return this.tblTagEditor.getAddAction();
    }

    public void clearSelection() {
        this.tblTagEditor.getSelectionModel().clearSelection();
    }

    public void stopEditing() {
        javax.swing.table.TableCellEditor editor = this.tblTagEditor.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        return ((TableCellEditor)this.tblTagEditor.getCellEditor()).getAutoCompletionList();
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.tblTagEditor.setAutoCompletionList(autoCompletionList);
    }

    public void setAutoCompletionCache(AutoCompletionCache acCache) {
        this.tblTagEditor.setAutoCompletionCache(acCache);
    }

    @Override
    public void autoCompletionItemSelected(String item) {
        TableCellEditor editor = (TableCellEditor)this.tblTagEditor.getCellEditor();
        if (editor != null) {
            editor.autoCompletionItemSelected(item);
        }
    }

    public void requestFocusInTopLeftCell() {
        this.tblTagEditor.requestFocusInCell(0, 0);
    }
}

