/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.editor.TagModel;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.Tag;
import org.openstreetmap.josm.tools.I18n;

public class TableCellRenderer
extends JLabel
implements javax.swing.table.TableCellRenderer {
    private static Logger logger = Logger.getLogger(TableCellRenderer.class.getName());
    public static final Color BG_COLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BG_COLOR_HIGHLIGHTED = new Color(255, 255, 204);
    public static final Border BORDER_EMPHASIZED = BorderFactory.createLineBorder(new Color(253, 75, 45));
    private ImageIcon deleteIcon = null;
    private Font fontStandard = this.getFont();
    private Font fontItalic = this.fontStandard.deriveFont(2);

    public TableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tag) {
        this.setText(tag.getName());
    }

    protected void renderTagValue(TagModel tag) {
        if (tag.getValueCount() == 0) {
            this.setText("");
        } else if (tag.getValueCount() == 1) {
            this.setText(tag.getValues().get(0));
        } else if (tag.getValueCount() > 1) {
            this.setText(I18n.tr((String)"<multiple>"));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    protected TagEditorModel getModel(JTable table) {
        return (TagEditorModel)table.getModel();
    }

    protected boolean belongsToSelectedPreset(TagModel tagModel, TagEditorModel model) {
        if (tagModel.getName().trim().equals("") && tagModel.getValue().equals("")) {
            return false;
        }
        Item item = (Item)model.getAppliedPresetsModel().getSelectedItem();
        if (item == null) {
            return false;
        }
        for (Tag tag : item.getTags()) {
            if (!(tag.getValue() == null ? tagModel.getName().equals(tag.getKey()) : tagModel.getName().equals(tag.getKey()) && tagModel.getValue().equals(tag.getValue()))) continue;
            return true;
        }
        return false;
    }

    protected void renderBackgroundColor(TagModel tagModel, TagEditorModel model) {
        this.setBackground(Color.WHITE);
        if (this.belongsToSelectedPreset(tagModel, model)) {
            this.setBackground(BG_COLOR_HIGHLIGHTED);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        this.resetRenderer();
        if (isSelected) {
            this.setBackground(BG_COLOR_SELECTED);
        } else {
            this.renderBackgroundColor(this.getModel(table).get(rowIndex), this.getModel(table));
        }
        switch (vColIndex) {
            case 0: {
                this.renderTagName((TagModel)value);
                break;
            }
            case 1: {
                this.renderTagValue((TagModel)value);
                break;
            }
            default: {
                throw new RuntimeException("unexpected index in switch statement");
            }
        }
        if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1) {
            boolean success = table.editCellAt(rowIndex, vColIndex);
            if (table.getEditorComponent() != null) {
                table.getEditorComponent().requestFocusInWindow();
            }
        }
        return this;
    }
}

