/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.tageditor.TagEditorDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LaunchAction
extends JosmAction
implements SelectionChangedListener {
    protected void registerAsMenuItem() {
        MainMenu menu = Main.main.menu;
        JMenu edit = null;
        JMenuItem item = new JMenuItem((Action)((Object)this));
        for (int i = 0; i < menu.getMenuCount(); ++i) {
            if (menu.getMenu(i) == null || !I18n.tr((String)"Edit").equals(menu.getMenu(i).getText())) continue;
            edit = menu.getMenu(i);
            break;
        }
        if (edit != null) {
            edit.insertSeparator(edit.getItemCount());
            JMenuItem mitem = edit.insert((Action)((Object)this), edit.getItemCount());
            mitem.setAccelerator(KeyStroke.getKeyStroke('T'));
        } else if (menu.getMenuCount() > 0) {
            edit = menu.getMenu(0);
            JMenuItem mitem = edit.insert((Action)((Object)this), 0);
            mitem.setAccelerator(KeyStroke.getKeyStroke('T'));
        }
        item.setVisible(true);
    }

    public LaunchAction() {
        super(I18n.tr((String)"Edit tags"), null, I18n.tr((String)"Launches the tag editor dialog"), Shortcut.registerShortcut((String)"edit:launchtageditor", (String)I18n.tr((String)"Launches the tag editor dialog"), (int)84, (int)3), false);
        DataSet.selListeners.add(this);
        this.registerAsMenuItem();
        this.setEnabled(false);
    }

    protected Window getTopWindow() {
        if (Main.contentPane == null) {
            return null;
        }
        Container c = Main.contentPane;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return null;
    }

    protected void placeDialogOnScreen(TagEditorDialog dialog) {
        Window w = this.getTopWindow();
        if (w == null) {
            return;
        }
        GraphicsConfiguration gc = w.getGraphicsConfiguration();
        Rectangle screenBounds = null;
        if (gc != null) {
            screenBounds = gc.getBounds();
        }
        Rectangle winBounds = w.getBounds();
        Dimension d = dialog.getPreferredSize();
        Point p = new Point();
        if (d.width <= winBounds.width && d.height <= winBounds.height) {
            p.x = winBounds.x + (winBounds.width - d.width) / 2;
            p.y = winBounds.y + (winBounds.height - d.height) / 2;
        } else {
            p.x = screenBounds.x + (screenBounds.width - d.width) / 2;
            p.y = screenBounds.y + (screenBounds.height - d.height) / 2;
        }
        dialog.setLocation(p);
    }

    protected void launchEditor() {
        if (!this.isEnabled()) {
            return;
        }
        TagEditorDialog dialog = TagEditorDialog.getInstance();
        this.placeDialogOnScreen(dialog);
        dialog.startEditSession();
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.launchEditor();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.setEnabled(newSelection != null && newSelection.size() > 0);
    }
}

