/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.tageditor.editor.TagModel;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.Tag;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.tools.I18n;

public class TagEditorModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(TagEditorModel.class.getName());
    public static final String PROP_DIRTY = TagEditorModel.class.getName() + ".dirty";
    private ArrayList<TagModel> tags = new ArrayList();
    private ArrayList<Item> items = new ArrayList();
    private boolean dirty = false;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private DefaultComboBoxModel appliedPresets = new DefaultComboBoxModel();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removeProperyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    protected void fireDirtyStateChanged(boolean oldValue, boolean newValue) {
        this.propChangeSupport.firePropertyChange(PROP_DIRTY, oldValue, newValue);
    }

    protected void setDirty(boolean newValue) {
        boolean oldValue = this.dirty;
        this.dirty = newValue;
        if (oldValue != newValue) {
            this.fireDirtyStateChanged(oldValue, newValue);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("unexpected rowIndex: rowIndex=" + rowIndex);
        }
        TagModel tag = this.tags.get(rowIndex);
        switch (columnIndex) {
            case 0: 
            case 1: {
                return tag;
            }
        }
        throw new IndexOutOfBoundsException("unexpected columnIndex: columnIndex=" + columnIndex);
    }

    public void clear() {
        this.tags.clear();
        this.items.clear();
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(TagModel tag) {
        if (tag == null) {
            throw new IllegalArgumentException("argument 'tag' must not be null");
        }
        this.tags.add(tag);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void prepend(TagModel tag) {
        if (tag == null) {
            throw new IllegalArgumentException("argument 'tag' must not be null");
        }
        this.tags.add(0, tag);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(String name, String value) {
        name = name == null ? "" : name;
        value = value == null ? "" : value;
        TagModel tag = this.get(name);
        if (tag == null) {
            tag = new TagModel(name, value);
            this.add(tag);
        } else {
            tag.addValue(value);
        }
        this.setDirty(true);
    }

    public TagModel get(String name) {
        name = name == null ? "" : name;
        for (TagModel tag : this.tags) {
            if (!tag.getName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    public TagModel get(int idx) {
        TagModel tagModel = this.tags.get(idx);
        return tagModel;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void deleteTagNames(int[] tagIndices) {
        if (this.tags == null) {
            return;
        }
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            tag.setName("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTagValues(int[] tagIndices) {
        if (this.tags == null) {
            return;
        }
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            tag.setValue("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTags(int[] tagIndices) {
        if (this.tags == null) {
            return;
        }
        ArrayList<TagModel> toDelete = new ArrayList<TagModel>();
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            toDelete.add(tag);
        }
        for (TagModel tag : toDelete) {
            this.tags.remove(tag);
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void appendNewTag() {
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void ensureOneTag() {
        if (this.tags.size() == 0) {
            this.appendNewTag();
        }
    }

    public void initFromJOSMSelection() {
        Collection selection = Main.ds.getSelected();
        this.clear();
        for (OsmPrimitive element : selection) {
            for (String key : element.keySet()) {
                String value = element.get(key);
                this.add(key, value);
            }
        }
        this.sort();
        this.setDirty(false);
    }

    public boolean includesTag(String key) {
        if (key == null) {
            return false;
        }
        for (TagModel tag : this.tags) {
            if (!tag.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    protected Command createUpdateTagCommand(Collection<OsmPrimitive> primitives, TagModel tag) {
        if (tag.getValueCount() > 1) {
            return null;
        }
        if (tag.getName().trim().equals("")) {
            return null;
        }
        String newkey = tag.getName();
        String newvalue = tag.getValue();
        ChangePropertyCommand command = new ChangePropertyCommand(primitives, newkey, newvalue);
        return command;
    }

    protected Command createDeleteTagsCommand(Collection<OsmPrimitive> primitives) {
        List<String> currentkeys = this.getKeys();
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        for (OsmPrimitive primitive : primitives) {
            if (primitive.keys == null) continue;
            for (String oldkey : primitive.keys.keySet()) {
                if (currentkeys.contains(oldkey)) continue;
                ChangePropertyCommand deleteCommand = new ChangePropertyCommand(primitive, oldkey, null);
                commands.add(deleteCommand);
            }
        }
        SequenceCommand command = new SequenceCommand(I18n.trn((String)"Remove old keys from up to {0} object", (String)"Remove old keys from up to {0} objects", (long)primitives.size(), (Object[])new Object[]{primitives.size()}), commands);
        return command;
    }

    public void updateJOSMSelection() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Collection selection = Main.ds.getSelected();
        if (selection == null) {
            return;
        }
        for (TagModel tag : this.tags) {
            Command command = this.createUpdateTagCommand(selection, tag);
            if (command == null) continue;
            commands.add(command);
        }
        Command deleteCommand = this.createDeleteTagsCommand(selection);
        if (deleteCommand != null) {
            commands.add(deleteCommand);
        }
        SequenceCommand command = new SequenceCommand(I18n.trn((String)"Updating properties of up to {0} object", (String)"Updating properties of up to {0} objects", (long)selection.size(), (Object[])new Object[]{selection.size()}), commands);
        Main.main.undoRedo.add((Command)command);
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (TagModel tag : this.tags) {
            if (tag.getName().trim().equals("")) continue;
            keys.add(tag.getName());
        }
        return keys;
    }

    protected void sort() {
        Collections.sort(this.tags, new Comparator<TagModel>(){

            @Override
            public int compare(TagModel self, TagModel other) {
                return self.getName().compareTo(other.getName());
            }
        });
    }

    public void applyPreset(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("argument 'item' must not be null");
        }
        for (int i = 0; i < this.appliedPresets.getSize(); ++i) {
            if (!this.appliedPresets.getElementAt(i).equals(item)) continue;
            return;
        }
        for (Tag tag : item.getTags()) {
            TagModel tagModel;
            if (tag.isOptional()) continue;
            if (!this.includesTag(tag.getKey())) {
                tagModel = new TagModel(tag.getKey(), tag.getValue());
                this.prepend(tagModel);
                continue;
            }
            tagModel = this.get(tag.getKey());
            if (tag.getValue() == null) continue;
            tagModel.setValue(tag.getValue());
        }
        this.appliedPresets.addElement(item);
        this.appliedPresets.setSelectedItem(item);
        this.fireTableDataChanged();
    }

    public void applyKeyValuePair(KeyValuePair pair) {
        TagModel tagModel = this.get(pair.getKey());
        if (tagModel == null) {
            tagModel = new TagModel(pair.getKey(), pair.getValue());
            this.prepend(tagModel);
        } else {
            tagModel.setValue(pair.getValue());
        }
        this.fireTableDataChanged();
    }

    public DefaultComboBoxModel getAppliedPresetsModel() {
        return this.appliedPresets;
    }

    public void removeAppliedPreset(Item item) {
        if (item == null) {
            return;
        }
        for (Tag tag : item.getTags()) {
            TagModel tagModel;
            if (tag.getValue() != null) {
                tagModel = this.get(tag.getKey());
                if (tagModel == null || !tag.getValue().equals(tagModel.getValue())) continue;
                this.tags.remove(tagModel);
                this.setDirty(true);
                continue;
            }
            tagModel = this.get(tag.getKey());
            if (tagModel == null) continue;
            this.tags.remove(tagModel);
            this.setDirty(true);
        }
        this.appliedPresets.removeElement(item);
        this.fireTableDataChanged();
    }

    public void clearAppliedPresets() {
        this.appliedPresets.removeAllElements();
        this.fireTableDataChanged();
    }

    public void highlightCurrentPreset() {
        this.fireTableDataChanged();
    }

    public void updateTagName(TagModel tag, String newName) {
        String oldName = tag.getName();
        tag.setName(newName);
        if (!newName.equals(oldName)) {
            logger.info("setting dirty ...");
            this.setDirty(true);
        }
    }

    public void updateTagValue(TagModel tag, String newValue) {
        String oldValue = tag.getValue();
        tag.setValue(newValue);
        if (!newValue.equals(oldValue)) {
            logger.info("setting dirty ...");
            this.setDirty(true);
        }
    }
}

