/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.jrt.core.RoutingGraph;
import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class RoutingMenu
extends JMenu {
    private static final long serialVersionUID = 3559922048225708480L;
    private JMenuItem startMI = new JMenuItem(I18n.tr((String)"Add routing layer"));
    private JMenuItem reverseMI;
    private JMenuItem clearMI;
    private JMenu criteriaM;

    public RoutingMenu(String name) {
        super(name);
        this.startMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoutingPlugin.getInstance().addLayer();
            }
        });
        this.add(this.startMI);
        this.addSeparator();
        ButtonGroup group = new ButtonGroup();
        this.criteriaM = new JMenu(I18n.tr((String)"Criteria"));
        JRadioButtonMenuItem rshorter = new JRadioButtonMenuItem(I18n.tr((String)"Shortest"));
        rshorter.setSelected(true);
        rshorter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
                    RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
                    RoutingModel routingModel = layer.getRoutingModel();
                    if (e.getStateChange() == 1) {
                        routingModel.routingGraph.setTypeRoute(RoutingGraph.RouteType.SHORTEST);
                    } else {
                        routingModel.routingGraph.setTypeRoute(RoutingGraph.RouteType.FASTEST);
                    }
                    routingModel.routingGraph.resetGraph();
                    routingModel.routingGraph.createGraph();
                    routingModel.setNodesChanged();
                    Main.map.repaint();
                }
            }
        });
        JRadioButtonMenuItem rfaster = new JRadioButtonMenuItem(I18n.tr((String)"Fastest"));
        group.add(rshorter);
        group.add(rfaster);
        this.criteriaM.add(rshorter);
        this.criteriaM.add(rfaster);
        this.criteriaM.addSeparator();
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Ignore oneways");
        cbmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
                    RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
                    RoutingModel routingModel = layer.getRoutingModel();
                    if (e.getStateChange() == 1) {
                        routingModel.routingGraph.getRoutingProfile().setOnewayUse(false);
                    } else {
                        routingModel.routingGraph.getRoutingProfile().setOnewayUse(true);
                    }
                    routingModel.setNodesChanged();
                    Main.map.repaint();
                }
            }
        });
        this.criteriaM.add(cbmi);
        this.add(this.criteriaM);
        this.addSeparator();
        this.reverseMI = new JMenuItem(I18n.tr((String)"Reverse route"));
        this.reverseMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
                    RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
                    RoutingModel routingModel = layer.getRoutingModel();
                    routingModel.reverseNodes();
                    Main.map.repaint();
                }
            }
        });
        this.add(this.reverseMI);
        this.clearMI = new JMenuItem(I18n.tr((String)"Clear route"));
        this.clearMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
                    RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
                    RoutingModel routingModel = layer.getRoutingModel();
                    routingModel.reset();
                    RoutingPlugin.getInstance().getRoutingDialog().clearNodes();
                    Main.map.repaint();
                }
            }
        });
        this.add(this.clearMI);
        this.disableAllItems();
    }

    public void disableAllItems() {
        this.startMI.setEnabled(false);
        this.reverseMI.setEnabled(false);
        this.clearMI.setEnabled(false);
        this.criteriaM.setEnabled(false);
    }

    public void enableStartItem() {
        this.startMI.setEnabled(true);
    }

    public void enableRestOfItems() {
        this.reverseMI.setEnabled(true);
        this.clearMI.setEnabled(true);
        this.criteriaM.setEnabled(true);
    }

    public void disableRestOfItems() {
        this.reverseMI.setEnabled(false);
        this.clearMI.setEnabled(false);
        this.criteriaM.setEnabled(false);
    }
}

