/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.tageditor.preset.Group;
import org.openstreetmap.josm.plugins.tageditor.preset.io.Parser;
import org.openstreetmap.josm.plugins.tageditor.preset.io.PresetIOException;
import org.openstreetmap.josm.plugins.tageditor.util.IndentWriter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Presets {
    private static Logger logger = Logger.getLogger(Presets.class.getName());
    private static Presets presets = null;
    private List<Group> groups = new ArrayList<Group>();

    public static void initPresets() {
        presets = new Presets();
        String allTaggingPresets = Main.pref.get("taggingpreset.sources");
        if (Main.pref.getBoolean("taggingpreset.enable-defaults", true)) {
            allTaggingPresets = "resource://presets/presets.xml" + (allTaggingPresets != null ? ";" + allTaggingPresets : "");
        }
        for (String source : allTaggingPresets.split(";")) {
            logger.log(Level.INFO, String.format("starting to read presets from source '%1$s'", source));
            try {
                InputStreamReader r;
                MirroredInputStream s = new MirroredInputStream(source);
                try {
                    r = new InputStreamReader((InputStream)s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader((InputStream)s);
                }
                presets = Presets.loadPresets(r, presets);
            }
            catch (PresetIOException e) {
                logger.log(Level.SEVERE, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}), e);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}));
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}));
            }
        }
    }

    public static Presets loadPresets(URL from) throws PresetIOException {
        try {
            URLConnection con = from.openConnection();
            con.connect();
            InputStreamReader reader = new InputStreamReader(con.getInputStream());
            return Presets.loadPresets(reader, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception caught while loading preset file", e);
            throw new PresetIOException(e);
        }
    }

    public static Presets loadPresets(Reader reader, Presets p) throws PresetIOException {
        try {
            Parser parser = new Parser();
            parser.setReader(reader);
            parser.setPresets(p);
            parser.parse();
            return parser.getPresets();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception caught while loading presets", e);
            throw new PresetIOException(e);
        }
    }

    public static Presets getPresets() {
        if (presets == null) {
            Presets.initPresets();
        }
        return presets;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public void dump(IndentWriter writer) throws IOException {
        writer.indent();
        writer.write("<presets>\n");
        writer.incLevel();
        for (Group group : this.groups) {
            group.dump(writer);
        }
        writer.decLevel();
        writer.indent();
        writer.write("</presets>");
    }

    public List<Group> getGroups() {
        return this.groups;
    }
}

