/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.ac;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionListItem;

public class AutoCompletionListRenderer
implements TableCellRenderer {
    public static final String RES_OSM_ICON = "/resources/osm.gif";
    public static final String RES_SELECTION_ICON = "/resources/selection.gif";
    public static final Color BG_COLOR_SELECTED = new Color(143, 170, 255);
    private JLabel renderer = new JLabel();
    private Icon iconStandard;
    private Icon iconSelection;

    public AutoCompletionListRenderer() {
        this.renderer.setOpaque(true);
        this.loadIcons();
    }

    protected void loadIcons() {
        URL imgURL = this.getClass().getResource(RES_OSM_ICON);
        if (imgURL != null) {
            this.iconStandard = new ImageIcon(imgURL);
        } else {
            System.err.println("Could not load icon: /resources/osm.gif");
            this.iconStandard = null;
        }
        imgURL = this.getClass().getResource(RES_SELECTION_ICON);
        if (imgURL != null) {
            this.iconSelection = new ImageIcon(imgURL);
        } else {
            System.err.println("Could not load icon: /resources/selection.gif");
            this.iconSelection = null;
        }
    }

    protected void prepareRendererIcon(AutoCompletionListItem item) {
        if (item.getPriority().equals(AutoCompletionItemPritority.IS_IN_STANDARD)) {
            if (this.iconStandard != null) {
                this.renderer.setIcon(this.iconStandard);
            }
        } else if (item.getPriority().equals(AutoCompletionItemPritority.IS_IN_SELECTION) && this.iconSelection != null) {
            this.renderer.setIcon(this.iconSelection);
        }
    }

    protected void resetRenderer() {
        this.renderer.setIcon(null);
        this.renderer.setText("");
        this.renderer.setOpaque(true);
        this.renderer.setBackground(Color.WHITE);
        this.renderer.setForeground(Color.BLACK);
    }

    protected void renderSelected() {
        this.renderer.setBackground(BG_COLOR_SELECTED);
        this.renderer.setForeground(Color.WHITE);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.resetRenderer();
        if (value instanceof AutoCompletionListItem) {
            AutoCompletionListItem item = (AutoCompletionListItem)value;
            this.prepareRendererIcon(item);
            this.renderer.setText(item.getValue());
        } else if (value != null) {
            this.renderer.setText(value.toString());
        } else {
            this.renderer.setText("<null>");
        }
        if (isSelected) {
            this.renderSelected();
        }
        return this.renderer;
    }
}

