/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.internal.reflection.ParameterReflection;
import mockit.internal.reflection.ThrowOfCheckedException;
import mockit.internal.util.StackTrace;
import mockit.internal.util.Utilities;

public final class MethodReflection {
    private static final Pattern JAVA_LANG = Pattern.compile("java.lang.", 16);

    private MethodReflection() {
    }

    @Nullable
    public static <T> T invokeWithCheckedThrows(@Nonnull Class<?> theClass, @Nullable Object targetInstance, @Nonnull String methodName, @Nonnull Class<?>[] paramTypes, Object ... methodArgs) throws Throwable {
        Method method = MethodReflection.findSpecifiedMethod(theClass, methodName, paramTypes);
        T result = MethodReflection.invokeWithCheckedThrows(targetInstance, method, methodArgs);
        return result;
    }

    @Nonnull
    private static Method findSpecifiedMethod(@Nonnull Class<?> theClass, @Nonnull String methodName, @Nonnull Class<?>[] paramTypes) {
        Method declaredMethod;
        while ((declaredMethod = MethodReflection.findSpecifiedMethodInGivenClass(theClass, methodName, paramTypes)) == null) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass == null || superClass == Object.class) {
                String paramTypesDesc = ParameterReflection.getParameterTypesDescription(paramTypes);
                throw new IllegalArgumentException("Specified method not found: " + methodName + paramTypesDesc);
            }
            theClass = superClass;
        }
        return declaredMethod;
    }

    @Nullable
    private static Method findSpecifiedMethodInGivenClass(@Nonnull Class<?> theClass, @Nonnull String methodName, @Nonnull Class<?>[] paramTypes) {
        for (Method declaredMethod : theClass.getDeclaredMethods()) {
            Class<?>[] declaredParameterTypes;
            int firstRealParameter;
            if (!declaredMethod.getName().equals(methodName) || (firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParameterTypes = declaredMethod.getParameterTypes(), paramTypes)) < 0 || !ParameterReflection.matchesParameterTypes(declaredMethod.getParameterTypes(), paramTypes, firstRealParameter)) continue;
            return declaredMethod;
        }
        return null;
    }

    @Nullable
    public static <T> T invokePublicIfAvailable(@Nonnull Class<?> aClass, @Nullable Object targetInstance, @Nonnull String methodName, @Nonnull Class<?>[] parameterTypes, Object ... methodArgs) {
        Method publicMethod;
        try {
            publicMethod = aClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
        T result = MethodReflection.invoke(targetInstance, publicMethod, methodArgs);
        return result;
    }

    @Nullable
    public static <T> T invoke(@Nullable Object targetInstance, @Nonnull Method method, Object ... methodArgs) {
        Utilities.ensureThatMemberIsAccessible(method);
        try {
            return (T)method.invoke(targetInstance, methodArgs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            StackTrace.filterStackTrace(e);
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            ThrowOfCheckedException.doThrow((Exception)cause);
            return null;
        }
    }

    @Nullable
    public static <T> T invokeWithCheckedThrows(@Nullable Object targetInstance, @Nonnull Method method, Object ... methodArgs) throws Throwable {
        Utilities.ensureThatMemberIsAccessible(method);
        try {
            return (T)method.invoke(targetInstance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            StackTrace.filterStackTrace(e);
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Nonnull
    public static Method findCompatibleMethod(@Nonnull Class<?> theClass, @Nonnull String methodName, @Nonnull Class<?>[] argTypes) {
        Method methodFound = MethodReflection.findCompatibleMethodIfAvailable(theClass, methodName, argTypes);
        if (methodFound != null) {
            return methodFound;
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible method found: " + methodName + argTypesDesc);
    }

    @Nullable
    private static Method findCompatibleMethodIfAvailable(@Nonnull Class<?> theClass, @Nonnull String methodName, @Nonnull Class<?>[] argTypes) {
        Method methodFound = null;
        while (true) {
            Class<?> superClass;
            Method compatibleMethod;
            if ((compatibleMethod = MethodReflection.findCompatibleMethodInClass(theClass, methodName, argTypes)) != null && (methodFound == null || ParameterReflection.hasMoreSpecificTypes(compatibleMethod.getParameterTypes(), methodFound.getParameterTypes()))) {
                methodFound = compatibleMethod;
            }
            if ((superClass = theClass.getSuperclass()) == null || superClass == Object.class) break;
            theClass = superClass;
        }
        return methodFound;
    }

    @Nullable
    private static Method findCompatibleMethodInClass(@Nonnull Class<?> theClass, @Nonnull String methodName, @Nonnull Class<?>[] argTypes) {
        Method found = null;
        Class<?>[] foundParamTypes = null;
        for (Method declaredMethod : theClass.getDeclaredMethods()) {
            Class<?>[] declaredParamTypes;
            int firstRealParameter;
            if (!declaredMethod.getName().equals(methodName) || (firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParamTypes = declaredMethod.getParameterTypes(), argTypes)) < 0 || !ParameterReflection.matchesParameterTypes(declaredParamTypes, argTypes, firstRealParameter) && !ParameterReflection.acceptsArgumentTypes(declaredParamTypes, argTypes, firstRealParameter) || foundParamTypes != null && !ParameterReflection.hasMoreSpecificTypes(declaredParamTypes, foundParamTypes)) continue;
            found = declaredMethod;
            foundParamTypes = declaredParamTypes;
        }
        return found;
    }

    @Nonnull
    public static Method findNonPrivateHandlerMethod(@Nonnull Object handler) {
        Method nonPrivateMethod;
        Class<?> handlerClass = handler.getClass();
        while ((nonPrivateMethod = MethodReflection.findNonPrivateHandlerMethod(handlerClass)) == null && (handlerClass = handlerClass.getSuperclass()) != null && handlerClass != Object.class) {
        }
        if (nonPrivateMethod == null) {
            throw new IllegalArgumentException("No non-private instance method found");
        }
        return nonPrivateMethod;
    }

    @Nullable
    private static Method findNonPrivateHandlerMethod(@Nonnull Class<?> handlerClass) {
        Method[] declaredMethods = handlerClass.getDeclaredMethods();
        Method found = null;
        for (Method declaredMethod : declaredMethods) {
            int methodModifiers = declaredMethod.getModifiers();
            if (Modifier.isPrivate(methodModifiers) || Modifier.isStatic(methodModifiers)) continue;
            if (found != null) {
                String methodType = Delegate.class.isAssignableFrom(handlerClass) ? "delegate" : "invocation handler";
                throw new IllegalArgumentException("More than one candidate " + methodType + " method found: " + MethodReflection.methodSignature(found) + ", " + MethodReflection.methodSignature(declaredMethod));
            }
            found = declaredMethod;
        }
        return found;
    }

    @Nonnull
    private static String methodSignature(@Nonnull Method method) {
        String signature = JAVA_LANG.matcher(method.toGenericString()).replaceAll("");
        int p = signature.lastIndexOf(40);
        int q = signature.lastIndexOf(46, p);
        return signature.substring(q + 1);
    }
}

