/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.asm.metadata.ClassMetadataReader;
import mockit.internal.ClassFile;

final class SuperConstructorCollector {
    @Nonnull
    static final SuperConstructorCollector INSTANCE = new SuperConstructorCollector();
    @Nonnull
    private final Map<String, String> cache = new HashMap<String, String>();

    private SuperConstructorCollector() {
    }

    @Nonnull
    synchronized String findConstructor(@Nonnull String classDesc, @Nonnull String superClassDesc) {
        String constructorDesc = this.cache.get(superClassDesc);
        if (constructorDesc != null) {
            return constructorDesc;
        }
        boolean samePackage = SuperConstructorCollector.areBothClassesAreInSamePackage(classDesc, superClassDesc);
        byte[] classfile = ClassFile.getClassFile(superClassDesc);
        ClassMetadataReader cmr = new ClassMetadataReader(classfile);
        for (ClassMetadataReader.MethodInfo methodOrConstructor : cmr.getMethods()) {
            int access = methodOrConstructor.accessFlags;
            if (access == 2 || access == 0 && !samePackage || !methodOrConstructor.isConstructor()) continue;
            constructorDesc = methodOrConstructor.desc;
            break;
        }
        assert (constructorDesc != null);
        this.cache.put(superClassDesc, constructorDesc);
        return constructorDesc;
    }

    private static boolean areBothClassesAreInSamePackage(@Nonnull String classDesc, @Nonnull String superClassDesc) {
        int p2;
        int p1 = classDesc.lastIndexOf(47);
        return p1 == (p2 = superClassDesc.lastIndexOf(47)) && (p1 < 0 || classDesc.substring(0, p1).equals(superClassDesc.substring(0, p2)));
    }
}

