/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.coverage.paths.Node;
import mockit.coverage.paths.NodeBuilder;
import mockit.coverage.paths.Path;
import mockit.coverage.paths.PathBuilder;

public final class MethodCoverageData
implements Serializable {
    private static final long serialVersionUID = -5073393714435522417L;
    @Nonnull
    private List<Node> nodes = Collections.emptyList();
    @Nonnegative
    private int firstLine;
    @Nonnegative
    private int lastLine;
    @Nonnull
    private final transient ThreadLocal<List<Node>> nodesReached;
    @Nonnull
    private final transient ThreadLocal<Integer> previousNodeIndex;
    @Nonnull
    public List<Path> paths = Collections.emptyList();
    @Nonnull
    private List<Path> nonShadowedPaths = Collections.emptyList();

    public MethodCoverageData() {
        this.nodesReached = new ThreadLocal();
        this.previousNodeIndex = new ThreadLocal();
        this.clearNodes();
    }

    public void buildPaths(@Nonnegative int lastExecutableLine, @Nonnull NodeBuilder nodeBuilder) {
        this.firstLine = nodeBuilder.firstLine;
        this.lastLine = lastExecutableLine;
        this.nodes = nodeBuilder.nodes;
        this.paths = PathBuilder.buildPaths(this.nodes);
        this.buildListOfNonShadowedPaths();
    }

    private void buildListOfNonShadowedPaths() {
        this.nonShadowedPaths = new ArrayList<Path>(this.paths.size());
        for (Path path : this.paths) {
            if (path.isShadowed()) continue;
            this.nonShadowedPaths.add(path);
        }
    }

    @Nonnegative
    public int getFirstLineInBody() {
        return this.firstLine;
    }

    @Nonnegative
    public int getLastLineInBody() {
        return this.lastLine;
    }

    int markNodeAsReached(@Nonnegative int nodeIndex) {
        if (nodeIndex == 0) {
            this.clearNodes();
        }
        if (nodeIndex < this.nodes.size()) {
            Node node = this.nodes.get(nodeIndex);
            List<Node> currentNodesReached = this.nodesReached.get();
            if (!(node.wasReached() || nodeIndex != 0 && nodeIndex <= this.previousNodeIndex.get())) {
                node.setReached(Boolean.TRUE);
                currentNodesReached.add(node);
                this.previousNodeIndex.set(nodeIndex);
            }
            if (node instanceof Node.Exit) {
                Node.Exit exitNode = (Node.Exit)node;
                for (Path path : exitNode.paths) {
                    int previousExecutionCount = path.countExecutionIfAllNodesWereReached(currentNodesReached);
                    if (previousExecutionCount < 0) continue;
                    return previousExecutionCount;
                }
            }
        }
        return -1;
    }

    private void clearNodes() {
        for (Node node : this.nodes) {
            node.setReached(null);
        }
        this.nodesReached.set(new ArrayList());
        this.previousNodeIndex.set(0);
    }

    @Nonnull
    public List<Path> getPaths() {
        return this.nonShadowedPaths;
    }

    @Nonnegative
    public int getExecutionCount() {
        int totalCount = 0;
        for (Path path : this.nonShadowedPaths) {
            totalCount += path.getExecutionCount();
        }
        return totalCount;
    }

    @Nonnegative
    public int getTotalPaths() {
        return this.nonShadowedPaths.size();
    }

    @Nonnegative
    public int getCoveredPaths() {
        int coveredCount = 0;
        for (Path path : this.nonShadowedPaths) {
            if (path.getExecutionCount() <= 0) continue;
            ++coveredCount;
        }
        return coveredCount;
    }

    void addCountsFromPreviousTestRun(@Nonnull MethodCoverageData previousData) {
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = this.paths.get(i);
            Path previousPath = previousData.paths.get(i);
            path.addCountFromPreviousTestRun(previousPath);
        }
    }
}

