/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.constantPool;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.ClassMemberItem;
import mockit.asm.constantPool.DoubleItem;
import mockit.asm.constantPool.FloatItem;
import mockit.asm.constantPool.IntItem;
import mockit.asm.constantPool.InvokeDynamicItem;
import mockit.asm.constantPool.Item;
import mockit.asm.constantPool.LongItem;
import mockit.asm.constantPool.MergedTypeTableItem;
import mockit.asm.constantPool.MethodHandleItem;
import mockit.asm.constantPool.NameAndTypeItem;
import mockit.asm.constantPool.NormalTypeTableItem;
import mockit.asm.constantPool.StringItem;
import mockit.asm.constantPool.TypeTableItem;
import mockit.asm.constantPool.UninitializedTypeTableItem;
import mockit.asm.types.MethodType;
import mockit.asm.types.PrimitiveType;
import mockit.asm.types.ReferenceType;
import mockit.asm.util.ByteVector;
import mockit.asm.util.MethodHandle;
import mockit.internal.util.ClassLoad;

public final class ConstantPoolGeneration {
    @Nonnull
    private final ByteVector pool = new ByteVector();
    @Nonnull
    private Item[] items = new Item[256];
    @Nonnegative
    private int threshold = (int)(0.75 * (double)this.items.length);
    @Nonnegative
    private int index = 1;
    @Nonnull
    private final StringItem reusableUTF8Item = new StringItem();
    @Nonnull
    private final StringItem reusableStringItem = new StringItem();
    @Nonnull
    private final NameAndTypeItem reusableNameTypeItem = new NameAndTypeItem(0);
    @Nonnull
    private final ClassMemberItem reusableClassMemberItem = new ClassMemberItem(0);
    @Nonnull
    private final IntItem reusableIntItem = new IntItem(0);
    @Nonnull
    private final LongItem reusableLongItem = new LongItem(0);
    @Nonnull
    private final FloatItem reusableFloatItem = new FloatItem(0);
    @Nonnull
    private final DoubleItem reusableDoubleItem = new DoubleItem(0);
    @Nonnull
    private final MethodHandleItem reusableMethodHandleItem = new MethodHandleItem(0);
    @Nonnull
    private final InvokeDynamicItem reusableInvokeDynamicItem = new InvokeDynamicItem(0);
    private TypeTableItem[] typeTable;
    private short typeCount;
    @Nonnull
    private final NormalTypeTableItem reusableNormalItem = new NormalTypeTableItem();
    @Nonnull
    private final UninitializedTypeTableItem reusableUninitializedItem = new UninitializedTypeTableItem();
    @Nonnull
    private final MergedTypeTableItem reusableMergedItem = new MergedTypeTableItem();

    @Nonnegative
    public int newUTF8(@Nonnull String value) {
        this.reusableUTF8Item.set(1, value);
        StringItem result = this.get(this.reusableUTF8Item);
        if (result == null) {
            this.pool.putByte(1).putUTF8(value);
            result = new StringItem(this.index++, this.reusableUTF8Item);
            this.put(result);
        }
        return result.index;
    }

    @Nonnegative
    public int newClass(@Nonnull String internalName) {
        return this.newClassItem((String)internalName).index;
    }

    @Nonnull
    public StringItem newClassItem(@Nonnull String internalName) {
        return this.newStringItem(7, internalName);
    }

    @Nonnull
    private StringItem newStringItem(int type, @Nonnull String value) {
        this.reusableStringItem.set(type, value);
        StringItem result = this.get(this.reusableStringItem);
        if (result == null) {
            int itemIndex = this.newUTF8(value);
            this.pool.put12(type, itemIndex);
            result = new StringItem(this.index++, this.reusableStringItem);
            this.put(result);
        }
        return result;
    }

    @Nonnull
    public MethodHandleItem newMethodHandleItem(@Nonnull MethodHandle methodHandle) {
        this.reusableMethodHandleItem.set(methodHandle);
        MethodHandleItem result = this.get(this.reusableMethodHandleItem);
        if (result == null) {
            int tag = methodHandle.tag;
            int memberType = tag == 9 ? 11 : 10;
            ClassMemberItem memberItem = this.newClassMemberItem(memberType, methodHandle.owner, methodHandle.name, methodHandle.desc);
            this.pool.put11(15, tag).putShort(memberItem.index);
            result = new MethodHandleItem(this.index++, this.reusableMethodHandleItem);
            this.put(result);
        }
        return result;
    }

    @Nonnull
    private ClassMemberItem newClassMemberItem(int type, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        this.reusableClassMemberItem.set(type, owner, name, desc);
        ClassMemberItem result = this.get(this.reusableClassMemberItem);
        if (result == null) {
            int ownerItemIndex = this.newClass(owner);
            int nameAndTypeItemIndex = this.newNameType(name, desc);
            this.put122(type, ownerItemIndex, nameAndTypeItemIndex);
            result = new ClassMemberItem(this.index++, this.reusableClassMemberItem);
            this.put(result);
        }
        return result;
    }

    @Nonnull
    public ClassMemberItem newFieldItem(@Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        return this.newClassMemberItem(9, owner, name, desc);
    }

    @Nonnull
    public ClassMemberItem newMethodItem(@Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        return this.newClassMemberItem(itf ? 11 : 10, owner, name, desc);
    }

    @Nonnull
    public IntItem newInteger(int value) {
        this.reusableIntItem.setValue(value);
        IntItem result = this.get(this.reusableIntItem);
        if (result == null) {
            this.pool.putByte(3).putInt(value);
            result = new IntItem(this.index++, this.reusableIntItem);
            this.put(result);
        }
        return result;
    }

    @Nonnull
    public FloatItem newFloat(float value) {
        this.reusableFloatItem.set(value);
        FloatItem result = this.get(this.reusableFloatItem);
        if (result == null) {
            this.pool.putByte(4).putInt(this.reusableFloatItem.intVal);
            result = new FloatItem(this.index++, this.reusableFloatItem);
            this.put(result);
        }
        return result;
    }

    @Nonnull
    public LongItem newLong(long value) {
        this.reusableLongItem.setValue(value);
        LongItem result = this.get(this.reusableLongItem);
        if (result == null) {
            this.pool.putByte(5).putLong(value);
            result = new LongItem(this.index, this.reusableLongItem);
            this.index += 2;
            this.put(result);
        }
        return result;
    }

    @Nonnull
    public DoubleItem newDouble(double value) {
        this.reusableDoubleItem.set(value);
        DoubleItem result = this.get(this.reusableDoubleItem);
        if (result == null) {
            this.pool.putByte(6).putLong(this.reusableDoubleItem.longVal);
            result = new DoubleItem(this.index, this.reusableDoubleItem);
            this.index += 2;
            this.put(result);
        }
        return result;
    }

    @Nonnegative
    private int newNameType(@Nonnull String name, @Nonnull String desc) {
        this.reusableNameTypeItem.set(name, desc);
        NameAndTypeItem result = this.get(this.reusableNameTypeItem);
        if (result == null) {
            int nameItemIndex = this.newUTF8(name);
            int descItemIndex = this.newUTF8(desc);
            this.put122(12, nameItemIndex, descItemIndex);
            result = new NameAndTypeItem(this.index++, this.reusableNameTypeItem);
            this.put(result);
        }
        return result.index;
    }

    @Nonnull
    public Item newConstItem(@Nonnull Object cst) {
        if (cst instanceof String) {
            return this.newStringItem(8, (String)cst);
        }
        if (cst instanceof Number) {
            return this.newNumberItem((Number)cst);
        }
        if (cst instanceof Character) {
            return this.newInteger(((Character)cst).charValue());
        }
        if (cst instanceof Boolean) {
            int val = (Boolean)cst != false ? 1 : 0;
            return this.newInteger(val);
        }
        if (cst instanceof ReferenceType) {
            String typeDesc = ((ReferenceType)cst).getInternalName();
            return cst instanceof MethodType ? this.newStringItem(16, typeDesc) : this.newClassItem(typeDesc);
        }
        if (cst instanceof PrimitiveType) {
            String typeDesc = ((PrimitiveType)cst).getDescriptor();
            return this.newClassItem(typeDesc);
        }
        if (cst instanceof MethodHandle) {
            return this.newMethodHandleItem((MethodHandle)cst);
        }
        throw new IllegalArgumentException("value " + cst);
    }

    @Nonnull
    private Item newNumberItem(@Nonnull Number cst) {
        if (cst instanceof Float) {
            return this.newFloat(cst.floatValue());
        }
        if (cst instanceof Long) {
            return this.newLong(cst.longValue());
        }
        if (cst instanceof Double) {
            return this.newDouble(cst.doubleValue());
        }
        return this.newInteger(cst.intValue());
    }

    @Nonnegative
    public int addNormalType(@Nonnull String type) {
        this.reusableNormalItem.set(type);
        TypeTableItem result = this.get(this.reusableNormalItem);
        if (result == null) {
            this.typeCount = (short)(this.typeCount + 1);
            result = new NormalTypeTableItem((int)this.typeCount, this.reusableNormalItem);
            this.addToTypeTable(result);
        }
        return result.index;
    }

    @Nonnegative
    public int addUninitializedType(@Nonnull String type, @Nonnegative int offset) {
        this.reusableUninitializedItem.set(type, offset);
        TypeTableItem result = this.get(this.reusableUninitializedItem);
        if (result == null) {
            this.typeCount = (short)(this.typeCount + 1);
            result = new UninitializedTypeTableItem((int)this.typeCount, this.reusableUninitializedItem);
            this.addToTypeTable(result);
        }
        return result.index;
    }

    private void addToTypeTable(@Nonnull TypeTableItem newItem) {
        this.put(newItem);
        if (this.typeTable == null) {
            this.typeTable = new TypeTableItem[16];
        }
        short newItemIndex = this.typeCount;
        this.enlargeTypeTableIfNeeded(newItemIndex);
        this.typeTable[newItemIndex] = newItem;
    }

    private void enlargeTypeTableIfNeeded(@Nonnegative int newItemIndex) {
        int currentTypeCount = this.typeTable.length;
        if (newItemIndex == currentTypeCount) {
            TypeTableItem[] newTable = new TypeTableItem[2 * currentTypeCount];
            System.arraycopy(this.typeTable, 0, newTable, 0, currentTypeCount);
            this.typeTable = newTable;
        }
    }

    @Nonnegative
    public int getMergedType(@Nonnegative int type1, @Nonnegative int type2) {
        this.reusableMergedItem.set(type1, type2);
        MergedTypeTableItem result = this.get(this.reusableMergedItem);
        if (result == null) {
            String type1Desc = this.getInternalName(type1);
            String type2Desc = this.getInternalName(type2);
            String commonSuperClass = ConstantPoolGeneration.getCommonSuperClass(type1Desc, type2Desc);
            this.reusableMergedItem.commonSuperTypeIndex = this.addNormalType(commonSuperClass);
            result = new MergedTypeTableItem(this.reusableMergedItem);
            this.put(result);
        }
        return result.commonSuperTypeIndex;
    }

    @Nonnull
    private static String getCommonSuperClass(@Nonnull String type1, @Nonnull String type2) {
        String class1 = type1;
        String class2 = type2;
        do {
            if ("java/lang/Object".equals(class1) || "java/lang/Object".equals(class2)) {
                return "java/lang/Object";
            }
            String superClass = ClassLoad.whichIsSuperClass(class1, class2);
            if (superClass == null) continue;
            return superClass;
        } while (!(class1 = ClassLoad.getSuperClass(class1)).equals(class2 = ClassLoad.getSuperClass(class2)));
        return class1;
    }

    @Nonnull
    public String getInternalName(@Nonnegative int typeTableIndex) {
        TypeTableItem typeTableItem = this.typeTable[typeTableIndex];
        return typeTableItem.typeDesc;
    }

    @Nonnull
    public UninitializedTypeTableItem getUninitializedItemValue(@Nonnegative int typeTableIndex) {
        return (UninitializedTypeTableItem)this.typeTable[typeTableIndex];
    }

    @Nullable
    public Item getItem(@Nonnegative int itemHashCode) {
        return this.items[itemHashCode % this.items.length];
    }

    @Nullable
    private <I extends Item> I get(@Nonnull I key) {
        Item item;
        int keyType = key.getType();
        for (item = this.getItem(key.getHashCode()); !(item == null || item.getType() == keyType && key.isEqualTo(item)); item = item.getNext()) {
        }
        return (I)item;
    }

    private void put(@Nonnull Item item) {
        this.resizeItemArrayIfNeeded();
        item.setNext(this.items);
    }

    private void resizeItemArrayIfNeeded() {
        if (this.index + this.typeCount > this.threshold) {
            int ll = this.items.length;
            int nl = ll * 2 + 1;
            Item[] newItems = new Item[nl];
            for (int l = ll - 1; l >= 0; --l) {
                Item j = this.items[l];
                ConstantPoolGeneration.put(newItems, j);
            }
            this.items = newItems;
            this.threshold = (int)((double)nl * 0.75);
        }
    }

    private static void put(@Nonnull Item[] newItems, @Nullable Item item) {
        while (item != null) {
            Item next = item.getNext();
            item.setNext(newItems);
            item = next;
        }
    }

    private void put122(int b, int s1, int s2) {
        this.pool.put12(b, s1).putShort(s2);
    }

    @Nonnegative
    public int getSize() {
        return this.pool.getLength();
    }

    public void checkConstantPoolMaxSize() {
        if (this.index > 65535) {
            throw new RuntimeException("Class file too large!");
        }
    }

    public void put(@Nonnull ByteVector out) {
        out.putShort(this.index).putByteVector(this.pool);
    }

    public void copy(@Nonnull byte[] code, @Nonnegative int off, @Nonnegative int header, @Nonnull Item[] cpItems) {
        this.pool.putByteArray(code, off, header - off);
        this.items = cpItems;
        int ll = cpItems.length;
        this.threshold = (int)(0.75 * (double)ll);
        this.index = ll;
    }

    @Nonnull
    public InvokeDynamicItem createInvokeDynamicItem(@Nonnull String name, @Nonnull String desc, @Nonnegative int bsmIndex) {
        this.reusableInvokeDynamicItem.set(name, desc, bsmIndex);
        InvokeDynamicItem result = this.get(this.reusableInvokeDynamicItem);
        if (result == null) {
            int nameAndTypeItemIndex = this.newNameType(name, desc);
            this.put122(18, bsmIndex, nameAndTypeItemIndex);
            result = new InvokeDynamicItem(this.index++, this.reusableInvokeDynamicItem);
            this.put(result);
        }
        return result;
    }
}

