/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.classGeneration.ConcreteSubclass;
import mockit.internal.faking.CaptureOfFakedImplementations;
import mockit.internal.faking.FakeClassSetup;
import mockit.internal.faking.FakeClasses;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;

public abstract class MockUp<T> {
    @Nonnull
    protected final Type targetType;

    protected MockUp() {
        MockUp<?> previousFake = this.findPreviouslyFakedClassIfFakeAlreadyApplied();
        if (previousFake != null) {
            this.targetType = previousFake.targetType;
            return;
        }
        this.targetType = this.getTypeToFake();
        Class classToFake = null;
        if (this.targetType instanceof Class) {
            classToFake = (Class)this.targetType;
        } else if (this.targetType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.targetType;
            classToFake = (Class)parameterizedType.getRawType();
        }
        if (classToFake != null) {
            this.redefineClass(classToFake);
        } else {
            Type[] typesToFake = ((TypeVariable)this.targetType).getBounds();
            if (typesToFake.length == 1) {
                new CaptureOfFakedImplementations(this, typesToFake[0]).apply();
            } else {
                throw new UnsupportedOperationException("Unable to capture more than one base type at once");
            }
        }
    }

    @Nullable
    private MockUp<?> findPreviouslyFakedClassIfFakeAlreadyApplied() {
        FakeClasses fakeClasses = TestRun.getFakeClasses();
        MockUp<?> previousFake = fakeClasses.findPreviouslyAppliedFake(this);
        return previousFake;
    }

    @Nonnull
    private Type getTypeToFake() {
        Class currentClass = this.getClass();
        Type superclass;
        while (!((superclass = currentClass.getGenericSuperclass()) instanceof ParameterizedType)) {
            if (superclass == MockUp.class) {
                throw new IllegalArgumentException("No target type");
            }
            currentClass = (Class)superclass;
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    private void redefineClass(@Nonnull Class<T> classToFake) {
        if (!classToFake.isInterface()) {
            Class<T> realClass = classToFake;
            if (Modifier.isAbstract(classToFake.getModifiers())) {
                classToFake = new ConcreteSubclass(classToFake).generateClass();
            }
            new FakeClassSetup(realClass, classToFake, this.targetType, this).redefineMethods();
        }
    }

    protected MockUp(@Nonnull Class<?> targetClass) {
        this.targetType = targetClass;
        MockUp<?> previousFake = this.findPreviouslyFakedClassIfFakeAlreadyApplied();
        if (previousFake != null) {
            return;
        }
        if (!targetClass.isInterface()) {
            new FakeClassSetup(targetClass, this).redefineMethods();
        }
    }

    protected void onTearDown() {
    }

    static {
        Startup.verifyInitialization();
    }
}

