/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;
import mockit.internal.expectations.invocation.ArgumentValuesAndMatchers;
import mockit.internal.expectations.invocation.ArgumentValuesAndMatchersWithVarargs;
import mockit.internal.expectations.invocation.ArgumentValuesAndMatchersWithoutVarargs;
import mockit.internal.expectations.invocation.UnexpectedInvocation;
import mockit.internal.expectations.state.ExecutingTest;
import mockit.internal.reflection.RealMethodOrConstructor;
import mockit.internal.state.ParameterNames;
import mockit.internal.state.TestRun;
import mockit.internal.util.MethodFormatter;

public final class InvocationArguments {
    @Nonnull
    final String classDesc;
    @Nonnull
    final String methodNameAndDesc;
    @Nullable
    final String genericSignature;
    @Nonnull
    private final ArgumentValuesAndMatchers valuesAndMatchers;
    @Nullable
    private Member realMethodOrConstructor;

    InvocationArguments(int access, @Nonnull String classDesc, @Nonnull String methodNameAndDesc, @Nullable String genericSignature, @Nonnull Object[] args) {
        this.classDesc = classDesc;
        this.methodNameAndDesc = methodNameAndDesc;
        this.genericSignature = genericSignature;
        this.valuesAndMatchers = (access & 0x80) == 0 ? new ArgumentValuesAndMatchersWithoutVarargs(this, args) : new ArgumentValuesAndMatchersWithVarargs(this, args);
    }

    @Nonnull
    String getClassName() {
        return this.classDesc.replace('/', '.');
    }

    boolean isForConstructor() {
        return this.methodNameAndDesc.charAt(0) == '<';
    }

    @Nonnull
    public Object[] getValues() {
        return this.valuesAndMatchers.values;
    }

    void setValues(@Nonnull Object[] values) {
        this.valuesAndMatchers.values = values;
    }

    public void setValuesWithNoMatchers(@Nonnull Object[] argsToVerify) {
        this.valuesAndMatchers.setValuesWithNoMatchers(argsToVerify);
    }

    public void setValuesAndMatchers(@Nonnull Object[] argsToVerify, @Nullable List<ArgumentMatcher<?>> matchers) {
        this.valuesAndMatchers.setValuesAndMatchers(argsToVerify, matchers);
    }

    @Nullable
    public List<ArgumentMatcher<?>> getMatchers() {
        return this.valuesAndMatchers.matchers;
    }

    public void setMatchers(@Nullable List<ArgumentMatcher<?>> matchers) {
        this.valuesAndMatchers.matchers = matchers;
    }

    @Nonnull
    public Object[] prepareForVerification(@Nonnull Object[] argsToVerify, @Nullable List<ArgumentMatcher<?>> matchers) {
        return this.valuesAndMatchers.prepareForVerification(argsToVerify, matchers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMatch(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        TestRun.enterNoMockingZone();
        ExecutingTest executingTest = TestRun.getExecutingTest();
        boolean previousFlag = executingTest.setShouldIgnoreMockingCallbacks(true);
        try {
            boolean bl = this.valuesAndMatchers.isMatch(replayArgs, instanceMap);
            return bl;
        }
        finally {
            executingTest.setShouldIgnoreMockingCallbacks(previousFlag);
            TestRun.exitNoMockingZone();
        }
    }

    @Nullable
    public Error assertMatch(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        return this.valuesAndMatchers.assertMatch(replayArgs, instanceMap);
    }

    @Nonnull
    Error argumentMismatchMessage(int paramIndex, @Nullable Object expected, @Nullable Object actual) {
        ArgumentMismatch message = new ArgumentMismatch();
        message.append("Parameter ");
        String parameterName = ParameterNames.getName(this.classDesc, this.methodNameAndDesc, paramIndex);
        if (parameterName == null) {
            message.append(paramIndex);
        } else {
            message.appendFormatted(parameterName);
        }
        message.append(" of ").append(new MethodFormatter(this.classDesc, this.methodNameAndDesc).toString());
        message.append(" expected ").appendFormatted(expected);
        if (!message.isFinished()) {
            message.append(", got ").appendFormatted(actual);
            if (actual != null) {
                InvocationArguments.appendWarningMessageAboutLackOfEqualsMethod(message, actual);
            }
        }
        return new UnexpectedInvocation(message.toString());
    }

    private static void appendWarningMessageAboutLackOfEqualsMethod(@Nonnull ArgumentMismatch message, @Nonnull Object value) {
        Method equalsMethod;
        Class<?> argClass = value.getClass();
        if (argClass == String.class || argClass == Boolean.class || argClass == Character.class || Number.class.isAssignableFrom(argClass)) {
            return;
        }
        try {
            equalsMethod = argClass.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (equalsMethod.getDeclaringClass() == Object.class) {
            message.append("\n   Warning: argument class ").append(argClass.getName()).append(" has no \"equals\" method");
        }
    }

    public String toString() {
        MethodFormatter methodFormatter = new MethodFormatter(this.classDesc, this.methodNameAndDesc, false);
        List<String> parameterTypes = methodFormatter.getParameterTypes();
        String arguments = this.valuesAndMatchers.toString(parameterTypes);
        methodFormatter.append(arguments);
        return methodFormatter.toString();
    }

    public boolean hasEquivalentMatchers(@Nonnull InvocationArguments other) {
        return this.valuesAndMatchers.hasEquivalentMatchers(other.valuesAndMatchers);
    }

    @Nonnull
    Member getRealMethodOrConstructor() {
        if (this.realMethodOrConstructor == null) {
            try {
                this.realMethodOrConstructor = new RealMethodOrConstructor(this.getClassName(), this.methodNameAndDesc).getMember();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return this.realMethodOrConstructor;
    }
}

