/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.controlFlow;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.controlFlow.Edge;
import mockit.asm.controlFlow.Frame;
import mockit.asm.util.ByteVector;

public final class Label {
    @Nullable
    public Object info;
    private int status;
    @Nonnegative
    public int line;
    @Nonnegative
    public int position;
    @Nonnegative
    private int referenceCount;
    private int[] srcAndRefPositions;
    @Nonnegative
    int inputStackTop;
    @Nonnegative
    int outputStackMax;
    Frame frame;
    @Nullable
    Label successor;
    Edge successors;
    @Nullable
    Label next;

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isDebug() {
        return (this.status & 1) != 0;
    }

    public boolean isResolved() {
        return (this.status & 2) != 0;
    }

    boolean isPushed() {
        return (this.status & 8) != 0;
    }

    public boolean isTarget() {
        return (this.status & 0x10) != 0;
    }

    public boolean isStoringFrame() {
        return (this.status & 0x20) != 0;
    }

    public boolean isReachable() {
        return (this.status & 0x40) != 0;
    }

    public void markAsDebug() {
        this.status |= 1;
    }

    private void markAsResolved() {
        this.status |= 2;
    }

    void markAsPushed() {
        this.status |= 8;
    }

    public void markAsTarget() {
        this.status |= 0x10;
    }

    void markAsStoringFrame() {
        this.status |= 0x20;
    }

    void markAsReachable() {
        this.status |= 0x40;
    }

    void markAsTarget(@Nonnull Label target) {
        this.status |= target.status & 0x10;
    }

    public void put(@Nonnull ByteVector out, @Nonnegative int source, boolean wideOffset) {
        if (this.isResolved()) {
            int reference = this.position - source;
            if (wideOffset) {
                out.putInt(reference);
            } else {
                out.putShort(reference);
            }
        } else if (wideOffset) {
            this.addReference(-1 - source, out.getLength());
            out.putInt(-1);
        } else {
            this.addReference(source, out.getLength());
            out.putShort(-1);
        }
    }

    private void addReference(@Nonnegative int sourcePosition, @Nonnegative int referencePosition) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] a = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, a, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = a;
        }
        this.srcAndRefPositions[this.referenceCount++] = sourcePosition;
        this.srcAndRefPositions[this.referenceCount++] = referencePosition;
    }

    void resolve(@Nonnull ByteVector methodBytecode) {
        int pos;
        this.markAsResolved();
        byte[] data = methodBytecode.getData();
        this.position = pos = methodBytecode.getLength();
        int[] srcAndRefPos = this.srcAndRefPositions;
        int refCount = this.referenceCount;
        for (int i = 0; i < refCount; i += 2) {
            int offset;
            int source = srcAndRefPos[i];
            int reference = srcAndRefPos[i + 1];
            if (source >= 0) {
                offset = pos - source;
            } else {
                offset = pos + source + 1;
                data[reference++] = (byte)(offset >>> 24);
                data[reference++] = (byte)(offset >>> 16);
            }
            data[reference++] = (byte)(offset >>> 8);
            data[reference] = (byte)offset;
        }
    }

    @Nonnull
    public Label getFirst() {
        return this.frame == null ? this : this.frame.owner;
    }

    @Nonnegative
    int decrementInputStackTop() {
        return --this.inputStackTop;
    }

    @Nonnegative
    void decrementInputStackTop(@Nonnegative int amount) {
        this.inputStackTop -= amount;
    }

    @Nullable
    public Label getSuccessor() {
        return this.successor;
    }

    @Nullable
    public Label setSuccessors(@Nonnull Edge edge) {
        edge.setNext(this.successors);
        this.successors = edge;
        return this.successor;
    }

    void updateOutputStackMaxHeight(@Nonnegative int outputStackTop) {
        int top = this.inputStackTop + outputStackTop;
        if (top > this.outputStackMax) {
            this.outputStackMax = top;
        }
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }

    static interface Status {
        public static final int DEBUG = 1;
        public static final int RESOLVED = 2;
        public static final int PUSHED = 8;
        public static final int TARGET = 16;
        public static final int STORE = 32;
        public static final int REACHABLE = 64;
    }
}

