/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.controlFlow.Label;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.types.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.MockingFilters;
import mockit.internal.expectations.ExecutionMode;
import mockit.internal.expectations.mocking.MockedBridge;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;
import mockit.internal.util.VisitInterruptedException;

final class MockedClassModifier
extends BaseClassModifier {
    private static final boolean NATIVE_UNSUPPORTED = !Utilities.HOTSPOT_VM;
    private static final int METHOD_ACCESS_MASK = 5122;
    private static final int PUBLIC_OR_PROTECTED = 5;
    @Nullable
    private final MockedType mockedType;
    private final boolean classFromNonBootstrapClassLoader;
    private String className;
    @Nullable
    private String baseClassNameForCapturedInstanceMethods;
    private boolean ignoreConstructors;
    private ExecutionMode executionMode;
    private boolean isProxy;
    @Nullable
    private String defaultFilters;
    @Nullable
    List<String> enumSubclasses;

    MockedClassModifier(@Nullable ClassLoader classLoader, @Nonnull ClassReader classReader, @Nullable MockedType typeMetadata) {
        super(classReader);
        this.mockedType = typeMetadata;
        this.classFromNonBootstrapClassLoader = classLoader != null;
        this.setUseClassLoadingBridge(classLoader);
        this.executionMode = ExecutionMode.Regular;
        this.useInstanceBasedMockingIfApplicable();
    }

    private void useInstanceBasedMockingIfApplicable() {
        if (this.mockedType != null && this.mockedType.injectable) {
            this.ignoreConstructors = !this.mockedType.withInstancesToCapture();
            this.executionMode = ExecutionMode.PerInstance;
        }
    }

    void setClassNameForCapturedInstanceMethods(@Nonnull String internalClassName) {
        this.baseClassNameForCapturedInstanceMethods = internalClassName;
    }

    void useDynamicMocking(boolean methodsOnly) {
        this.ignoreConstructors = methodsOnly;
        this.executionMode = ExecutionMode.Partial;
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        this.validateMockingOfJREClass(name);
        super.visit(version, access, name, additionalInfo);
        this.isProxy = "java/lang/reflect/Proxy".equals(additionalInfo.superName);
        if (this.isProxy) {
            this.className = additionalInfo.interfaces[0];
            this.defaultFilters = null;
        } else {
            this.className = name;
            this.defaultFilters = MockingFilters.filtersForClass(name);
            if (this.defaultFilters != null && this.defaultFilters.isEmpty()) {
                throw VisitInterruptedException.INSTANCE;
            }
        }
    }

    private void validateMockingOfJREClass(@Nonnull String internalName) {
        if (internalName.startsWith("java/")) {
            String modifyingClassName;
            if (MockingFilters.isUnmockable(internalName)) {
                throw new IllegalArgumentException("Class " + internalName.replace('/', '.') + " is not mockable");
            }
            if (this.executionMode == ExecutionMode.Regular && this.mockedType != null && MockingFilters.isFullMockingDisallowed(internalName) && (modifyingClassName = internalName.replace('/', '.')).equals(this.mockedType.getClassType().getName())) {
                throw new IllegalArgumentException("Class " + internalName.replace('/', '.') + " cannot be @Mocked fully; instead, use @Injectable or partial mocking");
            }
        }
    }

    @Override
    public void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.cw.visitInnerClass(name, outerName, innerName, access);
        if (access == 16392) {
            if (this.enumSubclasses == null) {
                this.enumSubclasses = new ArrayList<String>();
            }
            this.enumSubclasses.add(name);
        }
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if ((access & 0x1402) != 0) {
            return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
        }
        boolean visitingConstructor = "<init>".equals(name);
        ExecutionMode actualExecutionMode = this.determineAppropriateExecutionMode(visitingConstructor);
        String internalClassName = this.className;
        if (visitingConstructor) {
            if (this.isConstructorNotAllowedByMockingFilters(name)) {
                return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
            }
            this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
            this.generateCallToRegisterConstructorExecutionIfNeeded(actualExecutionMode);
            this.generateCallToSuperConstructor();
        } else {
            if (this.isMethodNotToBeMocked(access, name, desc)) {
                return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
            }
            if ("<clinit>".equals(name)) {
                return this.stubOutClassInitializationIfApplicable(access);
            }
            if (this.stubOutFinalizeMethod(access, name, desc)) {
                return null;
            }
            if (this.isMethodNotAllowedByMockingFilters(access, name)) {
                return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
            }
            this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
            if (this.baseClassNameForCapturedInstanceMethods != null) {
                internalClassName = this.baseClassNameForCapturedInstanceMethods;
            }
        }
        if (this.useClassLoadingBridge) {
            return this.generateCallToHandlerThroughMockingBridge(signature, internalClassName, visitingConstructor, actualExecutionMode);
        }
        this.generateDirectCallToHandler(internalClassName, access, name, desc, signature, actualExecutionMode);
        this.generateDecisionBetweenReturningOrContinuingToRealImplementation();
        return this.copyOriginalImplementationCode(visitingConstructor);
    }

    @Nonnull
    private MethodVisitor unmodifiedBytecode(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        return this.cw.visitMethod(access, name, desc, signature, exceptions);
    }

    @Nonnull
    private ExecutionMode determineAppropriateExecutionMode(boolean visitingConstructor) {
        if (this.executionMode == ExecutionMode.PerInstance) {
            if (visitingConstructor) {
                return this.ignoreConstructors ? ExecutionMode.Regular : ExecutionMode.Partial;
            }
            if (Modifier.isStatic(this.methodAccess)) {
                return ExecutionMode.Partial;
            }
        }
        return this.executionMode;
    }

    private boolean isConstructorNotAllowedByMockingFilters(@Nonnull String name) {
        return this.isProxy || this.ignoreConstructors || MockingFilters.isUnmockableInvocation(this.defaultFilters, name);
    }

    private boolean isMethodNotToBeMocked(int access, @Nonnull String name, @Nonnull String desc) {
        return Modifier.isNative(access) && (NATIVE_UNSUPPORTED || (access & 5) == 0) || (this.isProxy || this.executionMode == ExecutionMode.Partial) && (ObjectMethods.isMethodFromObject(name, desc) || "annotationType".equals(name) && "()Ljava/lang/Class;".equals(desc));
    }

    @Nullable
    private MethodVisitor stubOutClassInitializationIfApplicable(int access) {
        this.startModifiedMethodVersion(access, "<clinit>", "()V", null, null);
        if (this.mockedType != null && this.mockedType.isClassInitializationToBeStubbedOut()) {
            this.generateEmptyImplementation();
            return null;
        }
        return this.mw;
    }

    private boolean stubOutFinalizeMethod(int access, @Nonnull String name, @Nonnull String desc) {
        if ("finalize".equals(name) && "()V".equals(desc)) {
            this.startModifiedMethodVersion(access, name, desc, null, null);
            this.generateEmptyImplementation();
            return true;
        }
        return false;
    }

    private boolean isMethodNotAllowedByMockingFilters(int access, @Nonnull String name) {
        return this.baseClassNameForCapturedInstanceMethods != null && (access & 8) != 0 || this.executionMode.isMethodToBeIgnored(access) || MockingFilters.isUnmockableInvocation(this.defaultFilters, name);
    }

    private void generateCallToRegisterConstructorExecutionIfNeeded(@Nonnull ExecutionMode constructorExecutionMode) {
    }

    @Nonnull
    private MethodVisitor generateCallToHandlerThroughMockingBridge(@Nullable String genericSignature, @Nonnull String internalClassName, boolean visitingConstructor, @Nonnull ExecutionMode actualExecutionMode) {
        this.generateCodeToObtainInstanceOfClassLoadingBridge(MockedBridge.MB);
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitInsn(1);
        JavaType[] argTypes = JavaType.getArgumentTypes(this.methodDesc);
        this.generateCodeToCreateArrayOfObject(6 + argTypes.length);
        int i = 0;
        this.generateCodeToFillArrayElement(i++, this.methodAccess);
        this.generateCodeToFillArrayElement(i++, internalClassName);
        this.generateCodeToFillArrayElement(i++, this.methodName);
        this.generateCodeToFillArrayElement(i++, this.methodDesc);
        this.generateCodeToFillArrayElement(i++, genericSignature);
        this.generateCodeToFillArrayElement(i++, actualExecutionMode.ordinal());
        this.generateCodeToFillArrayWithParameterValues(argTypes, i, isStatic ? 0 : 1);
        this.generateCallToInvocationHandler();
        this.generateDecisionBetweenReturningOrContinuingToRealImplementation();
        return this.copyOriginalImplementationCode(visitingConstructor && this.classFromNonBootstrapClassLoader);
    }

    private void generateDecisionBetweenReturningOrContinuingToRealImplementation() {
        Label startOfRealImplementation = new Label();
        this.mw.visitInsn(89);
        this.mw.visitLdcInsn(VOID_TYPE);
        this.mw.visitJumpInsn(165, startOfRealImplementation);
        this.generateReturnWithObjectAtTopOfTheStack(this.methodDesc);
        this.mw.visitLabel(startOfRealImplementation);
        this.mw.visitInsn(87);
    }
}

