/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassLoadingBridge;
import mockit.internal.expectations.ExecutionMode;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.TestRun;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;

public final class MockedBridge
extends ClassLoadingBridge {
    @Nonnull
    public static final ClassLoadingBridge MB = new MockedBridge();

    private MockedBridge() {
        super("$MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(@Nullable Object mocked, Method method, @Nonnull Object[] args) throws Throwable {
        Object rv;
        boolean regularExecutionWithRecordReplayLock;
        String mockedClassDesc = (String)args[1];
        if (Utilities.calledFromSpecialThread() || MockedBridge.notToBeMocked(mocked, mockedClassDesc)) {
            return Void.class;
        }
        String mockName = (String)args[2];
        String mockDesc = (String)args[3];
        String mockNameAndDesc = mockName + mockDesc;
        Integer executionMode = (Integer)args[5];
        Object[] mockArgs = MockedBridge.extractArguments(6, args);
        boolean bl = regularExecutionWithRecordReplayLock = executionMode.intValue() == ExecutionMode.Regular.ordinal() && RecordAndReplayExecution.RECORD_OR_REPLAY_LOCK.isHeldByCurrentThread();
        if (regularExecutionWithRecordReplayLock && mocked != null && (rv = ObjectMethods.evaluateOverride(mocked, mockNameAndDesc, args)) != null) {
            return rv;
        }
        if (TestRun.getExecutingTest().isProceedingIntoRealImplementation() || regularExecutionWithRecordReplayLock || TestRun.isInsideNoMockingZone()) {
            return Void.class;
        }
        TestRun.enterNoMockingZone();
        try {
            int mockAccess = (Integer)args[0];
            String genericSignature = (String)args[4];
            rv = RecordAndReplayExecution.recordOrReplay(mocked, mockAccess, mockedClassDesc, mockNameAndDesc, genericSignature, executionMode, mockArgs);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
        return rv;
    }
}

