/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.exceptionHandling;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.controlFlow.Label;
import mockit.asm.util.ByteVector;

final class ExceptionHandler {
    @Nonnull
    Label start;
    @Nonnull
    Label end;
    @Nonnull
    final Label handler;
    @Nullable
    private final String desc;
    @Nonnegative
    private final int type;
    @Nullable
    ExceptionHandler next;

    ExceptionHandler(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String desc, @Nonnegative int type) {
        this.start = start;
        this.end = end;
        this.handler = handler;
        this.desc = desc;
        this.type = type;
    }

    @Nonnull
    String getCatchTypeDesc() {
        return this.desc == null ? "java/lang/Throwable" : this.desc;
    }

    @Nullable
    static ExceptionHandler remove(@Nullable ExceptionHandler h, @Nonnull Label start, @Nullable Label end) {
        int e;
        if (h == null) {
            return null;
        }
        h.next = ExceptionHandler.remove(h.next, start, end);
        int hStart = h.start.position;
        int hEnd = h.end.position;
        int s = start.position;
        int n = e = end == null ? Integer.MAX_VALUE : end.position;
        if (s < hEnd && e > hStart) {
            if (s <= hStart) {
                if (e >= hEnd) {
                    h = h.next;
                } else {
                    h.start = end;
                }
            } else if (e >= hEnd) {
                h.end = start;
            } else {
                ExceptionHandler g = new ExceptionHandler(end, h.end, h.handler, h.desc, h.type);
                g.next = h.next;
                h.end = start;
                h.next = g;
            }
        }
        return h;
    }

    void put(@Nonnull ByteVector out) {
        out.putShort(this.start.position).putShort(this.end.position);
        out.putShort(this.handler.position).putShort(this.type);
    }
}

