/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction
implements MouseListener {
    private JTextField url = new JTextField();
    private JTextField lat = new JTextField();
    private JTextField lon = new JTextField();
    private JTextField zm = new JTextField();
    private double zoomFactor = 0.0;

    public JumpToAction() {
        super(I18n.tr((String)"Jump To Position"), null, I18n.tr((String)"Opens a dialog that allows to jump to a specific location"), Shortcut.registerShortcut((String)"tools:jumpto", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Jump To Position")}), (int)71, (int)1), true);
    }

    public void showJumpToDialog() {
        LatLon curPos = Main.proj.eastNorth2latlon(Main.map.mapView.getCenter());
        this.lat.setText(Double.toString(curPos.lat()));
        this.lon.setText(Double.toString(curPos.lon()));
        LatLon ll1 = Main.map.mapView.getLatLon(0, 0);
        LatLon ll2 = Main.map.mapView.getLatLon(100, 0);
        double dist = ll1.greatCircleDistance(ll2);
        this.zoomFactor = Main.map.mapView.getScale() / dist;
        this.zm.setText(Long.toString(Math.round(dist * 100.0) / 100L));
        this.updateUrl(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html>" + I18n.tr((String)"Enter Lat/Lon to jump to position.") + "<br>" + I18n.tr((String)"You can also paste an URL from www.openstreetmap.org") + "<br>" + "</html>"), "North");
        class OsmLonLatListener
        implements DocumentListener {
            OsmLonLatListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }

            public void insertUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }

            public void removeUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }
        }
        OsmLonLatListener x = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(x);
        this.lon.getDocument().addDocumentListener(x);
        this.zm.getDocument().addDocumentListener(x);
        class OsmURLListener
        implements DocumentListener {
            OsmURLListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }

            public void insertUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }

            public void removeUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }
        }
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "North");
        p.add((Component)new JLabel(I18n.tr((String)"Latitude")), GBC.eol());
        p.add((Component)this.lat, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"Longitude")), GBC.eol());
        p.add((Component)this.lon, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"Zoom (in metres)")), GBC.eol());
        p.add((Component)this.zm, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"URL")), GBC.eol());
        p.add((Component)this.url, GBC.eol().fill(2));
        Object[] buttons = new Object[]{I18n.tr((String)"Jump there"), I18n.tr((String)"Cancel")};
        LatLon ll = null;
        double zoomLvl = 100.0;
        while (ll == null) {
            int option = JOptionPane.showOptionDialog(Main.parent, panel, I18n.tr((String)"Jump to Position"), 2, -1, null, buttons, buttons[0]);
            if (option != 0) {
                return;
            }
            try {
                zoomLvl = Double.parseDouble(this.zm.getText());
                ll = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not parse Latitude, Longitude or Zoom. Please check."), I18n.tr((String)"Unable to parse Lon/Lat"), 0);
            }
        }
        Main.map.mapView.zoomTo(Main.proj.latlon2eastNorth(ll), this.zoomFactor * zoomLvl);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        Bounds b = OsmUrlToBounds.parse((String)this.url.getText());
        if (b != null) {
            String[] args;
            this.lat.setText(Double.toString((b.min.lat() + b.max.lat()) / 2.0));
            this.lon.setText(Double.toString((b.min.lon() + b.max.lon()) / 2.0));
            int zoomLvl = 16;
            for (String arg : args = this.url.getText().substring(this.url.getText().indexOf(63) + 1).split("&")) {
                int eq = arg.indexOf(61);
                if (eq == -1 || !arg.substring(0, eq).equalsIgnoreCase("zoom")) continue;
                zoomLvl = Integer.parseInt(arg.substring(eq + 1));
                break;
            }
            this.zm.setText(Double.toString(Math.round(1.0E7 * Math.pow(2.0, -1 * zoomLvl))));
        }
    }

    private void updateUrl(boolean force) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || force)) {
            return;
        }
        try {
            double dlat = Double.parseDouble(this.lat.getText());
            double dlon = Double.parseDouble(this.lon.getText());
            int zoomLvl = this.getZoom(this.zoomFactor * Double.parseDouble(this.zm.getText()));
            int decimals = (int)Math.pow(10.0, zoomLvl / 3);
            dlat = Math.round(dlat * (double)decimals);
            dlon = Math.round(dlon * (double)decimals);
            this.url.setText("http://www.openstreetmap.org/?lat=" + (dlat /= (double)decimals) + "&lon=" + (dlon /= (double)decimals) + "&zoom=" + zoomLvl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.showJumpToDialog();
    }

    public int getZoom(double scale) {
        double sizex = scale * (double)Main.map.mapView.getWidth();
        double sizey = scale * (double)Main.map.mapView.getHeight();
        int zoom = 0;
        while (zoom <= 32) {
            block4: {
                block3: {
                    MapView cfr_ignored_0 = Main.map.mapView;
                    if (sizex > MapView.world.east()) break block3;
                    MapView cfr_ignored_1 = Main.map.mapView;
                    if (!(sizey > MapView.world.north())) break block4;
                }
                return zoom;
            }
            ++zoom;
            sizex *= 2.0;
            sizey *= 2.0;
        }
        return 32;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.showJumpToDialog();
    }
}

