/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojLayer;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojPlugin;
import org.openstreetmap.josm.plugins.agpifoj.ImageDisplay;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PrimaryDateParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelateGpxWithImages
implements ActionListener {
    private static List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    AgpifojLayer yLayer = null;
    Vector gpxLst = new Vector();
    JPanel panel = null;
    JComboBox cbGpx = null;
    JTextField tfTimezone = null;
    JTextField tfOffset = null;
    JRadioButton rbAllImg = null;
    JRadioButton rbUntaggedImg = null;
    JRadioButton rbNoExifImg = null;
    private int dayOffset;
    private JLabel lblMatches;
    private JLabel lblOffset;
    private JLabel lblTimezone;
    private JLabel lblMinutes;
    private JLabel lblSeconds;
    private JSlider sldTimezone;
    private JSlider sldMinutes;
    private JSlider sldSeconds;
    private GpxData autoGpx;
    private ArrayList<AgpifojLayer.ImageEntry> autoImgs;
    private long firstGPXDate = -1L;
    private long firstExifDate = -1L;

    public CorrelateGpxWithImages(AgpifojLayer layer) {
        this.yLayer = layer;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Collection layerLst = Main.map.mapView.getAllLayers();
        for (Layer cur : layerLst) {
            if (!(cur instanceof GpxLayer)) continue;
            this.gpxLst.add(new GpxDataWrapper(((GpxLayer)cur).name, ((GpxLayer)cur).data, ((GpxLayer)cur).data.storageFile));
        }
        for (GpxData data : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(data.storageFile.getName(), data, data.storageFile));
        }
        if (this.gpxLst.size() == 0) {
            this.gpxLst.add(I18n.tr((String)"<No GPX track loaded yet>"));
        }
        JPanel panelCb = new JPanel();
        panelCb.setLayout(new FlowLayout());
        panelCb.add(new JLabel(I18n.tr((String)"GPX track: ")));
        this.cbGpx = new JComboBox(this.gpxLst);
        panelCb.add(this.cbGpx);
        JButton buttonOpen = new JButton(I18n.tr((String)"Open another GPX trace"));
        buttonOpen.setIcon(ImageProvider.get((String)"agpifoj-open"));
        buttonOpen.addActionListener(new LoadGpxDataActionListener());
        panelCb.add(buttonOpen);
        JPanel panelTf = new JPanel();
        panelTf.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridy = 0;
        gc.gridx = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        panelTf.add((Component)new JLabel(I18n.tr((String)"Timezone: ")), gc);
        float gpstimezone = Float.parseFloat(Main.pref.get("tagimages.doublegpstimezone", "0.0"));
        if ((double)gpstimezone == 0.0) {
            gpstimezone = -Long.parseLong(Main.pref.get("tagimages.gpstimezone", "0"));
        }
        this.tfTimezone = new JTextField();
        this.tfTimezone.setText(this.formatTimezone(gpstimezone));
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panelTf.add((Component)this.tfTimezone, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        panelTf.add((Component)new JLabel(I18n.tr((String)"Offset:")), gc);
        long delta = Long.parseLong(Main.pref.get("tagimages.delta", "0")) / 1000L;
        this.tfOffset = new JTextField();
        this.tfOffset.setText(Long.toString(delta));
        gc.gridy = 1;
        gc.gridx = 1;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panelTf.add((Component)this.tfOffset, gc);
        JButton buttonViewGpsPhoto = new JButton(I18n.tr((String)"<html>I can take a picture of my GPS receiver.<br>Can this help?</html>"));
        buttonViewGpsPhoto.addActionListener(new SetOffsetActionListener());
        gc.gridx = 2;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 2;
        gc.fill = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        panelTf.add((Component)buttonViewGpsPhoto, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        panelTf.add((Component)new JLabel(I18n.tr((String)"Update position for: ")), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.rbAllImg = new JRadioButton(I18n.tr((String)"All images"));
        panelTf.add((Component)this.rbAllImg, gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.rbNoExifImg = new JRadioButton(I18n.tr((String)"Images with no exif position"));
        panelTf.add((Component)this.rbNoExifImg, gc);
        gc.gridx = 1;
        gc.gridy = 4;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.rbUntaggedImg = new JRadioButton(I18n.tr((String)"Not yet tagged images"));
        panelTf.add((Component)this.rbUntaggedImg, gc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbAllImg);
        group.add(this.rbNoExifImg);
        group.add(this.rbUntaggedImg);
        this.rbUntaggedImg.setSelected(true);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)panelCb, "First");
        this.panel.add((Component)panelTf, "Center");
        boolean isOk = false;
        GpxDataWrapper selectedGpx = null;
        while (!isOk) {
            block15: {
                int answer = new ExtendedDialog(Main.parent, I18n.tr((String)"Correlate images with GPX track"), (Component)this.panel, new String[]{I18n.tr((String)"Correlate"), I18n.tr((String)"Auto-Guess"), I18n.tr((String)"Cancel")}, new String[]{"ok.png", "dialogs/gpx2imgManual.png", "cancel.png"}).getValue();
                if (answer != 1 && answer != 2) {
                    return;
                }
                Object item = this.cbGpx.getSelectedItem();
                if (item == null || !(item instanceof GpxDataWrapper)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You should select a GPX track"), I18n.tr((String)"No selected GPX track"), 0);
                    continue;
                }
                selectedGpx = (GpxDataWrapper)item;
                if (answer == 2) {
                    this.autoGuess(selectedGpx.data);
                    return;
                }
                Float timezoneValue = this.parseTimezone(this.tfTimezone.getText().trim());
                if (timezoneValue == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing timezone.\nExpected format: {0}", (Object[])new Object[]{"+H:MM"}), I18n.tr((String)"Invalid timezone"), 0);
                    continue;
                }
                gpstimezone = timezoneValue.floatValue();
                String deltaText = this.tfOffset.getText().trim();
                if (deltaText.length() > 0) {
                    try {
                        if (deltaText.startsWith("+")) {
                            deltaText = deltaText.substring(1);
                        }
                        delta = Long.parseLong(deltaText);
                        break block15;
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing offset.\nExpected format: {0}", (Object[])new Object[]{"number"}), I18n.tr((String)"Invalid offset"), 0);
                        continue;
                    }
                }
                delta = 0L;
            }
            Main.pref.put("tagimages.doublegpstimezone", Double.toString(gpstimezone));
            Main.pref.put("tagimages.gpstimezone", Long.toString(-((long)gpstimezone)));
            Main.pref.put("tagimages.delta", Long.toString(delta * 1000L));
            isOk = true;
        }
        ArrayList<AgpifojLayer.ImageEntry> dateImgLst = this.getSortedImgList(this.rbAllImg.isSelected(), this.rbNoExifImg.isSelected());
        int matched = this.matchGpxTrack(dateImgLst, selectedGpx.data, (long)(gpstimezone * 3600.0f) + delta);
        Collection layerCol = Main.map.mapView.getAllLayers();
        Iterator layerIter = layerCol.iterator();
        boolean boundingBoxedLayerFound = false;
        while (layerIter.hasNext()) {
            Layer l = (Layer)layerIter.next();
            if (l == this.yLayer) continue;
            BoundingXYVisitor bbox = new BoundingXYVisitor();
            l.visitBoundingBox(bbox);
            if (bbox.min == null || bbox.max == null) continue;
            boundingBoxedLayerFound = true;
            break;
        }
        if (!boundingBoxedLayerFound) {
            BoundingXYVisitor bbox = new BoundingXYVisitor();
            this.yLayer.visitBoundingBox(bbox);
            Main.map.mapView.recalculateCenterScale(bbox);
        }
        Main.map.repaint();
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Found {0} matches of {1} in GPX track {2}", (Object[])new Object[]{matched, dateImgLst.size(), selectedGpx.name}), I18n.tr((String)"GPX Track loaded"), dateImgLst.size() > 0 && matched == 0 ? 2 : 1);
    }

    private void autoGuess(GpxData gpx) {
        long diff;
        this.autoGpx = gpx;
        this.autoImgs = this.getSortedImgList(true, false);
        PrimaryDateParser dateParser = new PrimaryDateParser();
        if (this.autoImgs.size() <= 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected photos don't contain time information."), I18n.tr((String)"Photos don't contain time information"), 2);
            return;
        }
        Main.pleaseWaitDlg.setVisible(false);
        AgpifojDialog dialog = AgpifojDialog.getInstance();
        dialog.action.button.setSelected(true);
        dialog.action.actionPerformed(null);
        if (!dialog.hasImage()) {
            this.yLayer.showNextPhoto();
        }
        this.firstExifDate = this.autoImgs.get((int)0).time.getTime() / 1000L;
        block4: for (GpxTrack trk : gpx.tracks) {
            for (Collection segment : trk.trackSegs) {
                for (WayPoint curWp : segment) {
                    String curDateWpStr = (String)curWp.attr.get("time");
                    if (curDateWpStr == null) continue;
                    try {
                        this.firstGPXDate = dateParser.parse(curDateWpStr).getTime() / 1000L;
                        break block4;
                    }
                    catch (Exception e) {
                    }
                }
            }
        }
        if (this.firstGPXDate < 0L) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected GPX track doesn't contain timestamps. Please select another one."), I18n.tr((String)"GPX Track has no time information"), 2);
            return;
        }
        this.yLayer.timeoffset = diff = this.yLayer.hasTimeoffset ? this.yLayer.timeoffset : this.firstExifDate - this.firstGPXDate;
        this.yLayer.hasTimeoffset = true;
        double diffInH = (double)diff / 3600.0;
        this.dayOffset = (int)Math.round(diffInH / 24.0);
        double timezone = diff - (long)(this.dayOffset * 24 * 60 * 60);
        timezone = (double)Math.round(timezone * 100.0 / 3600.0) / 100.0;
        double fixTimezone = (double)Math.round(timezone * 2.0) / 2.0;
        int offset = (int)Math.round((double)diff - fixTimezone * 60.0 * 60.0) - this.dayOffset * 24 * 60 * 60;
        this.lblMatches = new JLabel();
        this.lblOffset = new JLabel();
        this.lblTimezone = new JLabel();
        this.sldTimezone = new JSlider(-24, 24, 0);
        this.sldTimezone.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(-24, new JLabel("-12:00"));
        labelTable.put(-12, new JLabel("-6:00"));
        labelTable.put(0, new JLabel("0:00"));
        labelTable.put(12, new JLabel("6:00"));
        labelTable.put(24, new JLabel("12:00"));
        this.sldTimezone.setLabelTable(labelTable);
        this.lblMinutes = new JLabel();
        this.sldMinutes = new JSlider(-15, 15, 0);
        this.sldMinutes.setPaintLabels(true);
        this.sldMinutes.setMajorTickSpacing(5);
        this.lblSeconds = new JLabel();
        this.sldSeconds = new JSlider(-60, 60, 0);
        this.sldSeconds.setPaintLabels(true);
        this.sldSeconds.setMajorTickSpacing(30);
        JPanel p = new JPanel(new GridBagLayout());
        p.setPreferredSize(new Dimension(400, 230));
        p.add((Component)this.lblMatches, GBC.eol().fill());
        p.add((Component)this.lblOffset, GBC.eol().fill().insets(0, 0, 0, 10));
        p.add((Component)this.lblTimezone, GBC.eol().fill());
        p.add((Component)this.sldTimezone, GBC.eol().fill().insets(0, 0, 0, 10));
        p.add((Component)this.lblMinutes, GBC.eol().fill());
        p.add((Component)this.sldMinutes, GBC.eol().fill().insets(0, 0, 0, 10));
        p.add((Component)this.lblSeconds, GBC.eol().fill());
        p.add((Component)this.sldSeconds, GBC.eol().fill());
        try {
            this.sldTimezone.setValue((int)(fixTimezone * 2.0));
            this.sldMinutes.setValue(offset / 60);
            this.sldSeconds.setValue(offset % 60);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"An error occured while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos."), I18n.tr((String)"Matching photos to track failed"), 2);
        }
        class SliderListener
        implements ChangeListener {
            SliderListener() {
            }

            public void stateChanged(ChangeEvent e) {
                String zone;
                double tz = Math.abs(CorrelateGpxWithImages.this.sldTimezone.getValue());
                String string = zone = tz % 2.0 == 0.0 ? (int)Math.floor(tz / 2.0) + ":00" : (int)Math.floor(tz / 2.0) + ":30";
                if (CorrelateGpxWithImages.this.sldTimezone.getValue() < 0) {
                    zone = "-" + zone;
                }
                CorrelateGpxWithImages.this.lblTimezone.setText(I18n.tr((String)"Timezone: {0}", (Object[])new Object[]{zone}));
                CorrelateGpxWithImages.this.lblMinutes.setText(I18n.tr((String)"Minutes: {0}", (Object[])new Object[]{CorrelateGpxWithImages.this.sldMinutes.getValue()}));
                CorrelateGpxWithImages.this.lblSeconds.setText(I18n.tr((String)"Seconds: {0}", (Object[])new Object[]{CorrelateGpxWithImages.this.sldSeconds.getValue()}));
                float gpstimezone = CorrelateGpxWithImages.this.parseTimezone(zone).floatValue();
                for (AgpifojLayer.ImageEntry x : CorrelateGpxWithImages.this.autoImgs) {
                    x.coor = null;
                    x.pos = null;
                }
                long timediff = (long)(gpstimezone * 3600.0f) + (long)(CorrelateGpxWithImages.this.dayOffset * 24 * 60 * 60) + (long)(CorrelateGpxWithImages.this.sldMinutes.getValue() * 60) + (long)CorrelateGpxWithImages.this.sldSeconds.getValue();
                int matched = CorrelateGpxWithImages.this.matchGpxTrack(CorrelateGpxWithImages.this.autoImgs, CorrelateGpxWithImages.this.autoGpx, timediff);
                CorrelateGpxWithImages.this.lblMatches.setText(I18n.tr((String)"Matched {0} of {1} photos to GPX track.", (Object[])new Object[]{matched, CorrelateGpxWithImages.this.autoImgs.size()}) + (Math.abs(CorrelateGpxWithImages.this.dayOffset) == 0 ? "" : " " + I18n.tr((String)"(Time difference of {0} days)", (Object[])new Object[]{Math.abs(CorrelateGpxWithImages.this.dayOffset)})));
                int offset = (int)(CorrelateGpxWithImages.this.firstGPXDate + timediff - CorrelateGpxWithImages.this.firstExifDate);
                int o = Math.abs(offset);
                CorrelateGpxWithImages.this.lblOffset.setText(I18n.tr((String)"Offset between track and photos: {0}m {1}s", (Object[])new Object[]{(offset < 0 ? "-" : "") + Long.toString(Math.round(o / 60)), Long.toString(Math.round(o % 60))}));
                CorrelateGpxWithImages.this.yLayer.timeoffset = timediff;
                Main.map.repaint();
            }
        }
        new SliderListener().stateChanged(null);
        this.sldTimezone.addChangeListener(new SliderListener());
        this.sldMinutes.addChangeListener(new SliderListener());
        this.sldSeconds.addChangeListener(new SliderListener());
        int answer = new ExtendedDialog(Main.parent, I18n.tr((String)"Adjust timezone and offset"), (Component)p, new String[]{I18n.tr((String)"Close"), I18n.tr((String)"Default Values")}, new String[]{"ok.png", "dialogs/refresh.png"}).getValue();
        if (answer == 2) {
            this.yLayer.hasTimeoffset = false;
            this.autoGuess(gpx);
        }
    }

    private ArrayList<AgpifojLayer.ImageEntry> getSortedImgList(boolean all, boolean noexif) {
        ArrayList<AgpifojLayer.ImageEntry> dateImgLst = new ArrayList<AgpifojLayer.ImageEntry>(this.yLayer.data.size());
        if (all) {
            for (AgpifojLayer.ImageEntry e : this.yLayer.data) {
                if (e.time == null) continue;
                e.coor = null;
                e.pos = null;
                dateImgLst.add(e);
            }
        } else if (noexif) {
            for (AgpifojLayer.ImageEntry e : this.yLayer.data) {
                if (e.time == null || e.exifCoor != null) continue;
                dateImgLst.add(e);
            }
        } else {
            for (AgpifojLayer.ImageEntry e : this.yLayer.data) {
                if (e.time == null || e.coor != null) continue;
                dateImgLst.add(e);
            }
        }
        Collections.sort(dateImgLst, new Comparator<AgpifojLayer.ImageEntry>(){

            @Override
            public int compare(AgpifojLayer.ImageEntry arg0, AgpifojLayer.ImageEntry arg1) {
                return arg0.time.compareTo(arg1.time);
            }
        });
        return dateImgLst;
    }

    private int matchGpxTrack(ArrayList<AgpifojLayer.ImageEntry> dateImgLst, GpxData selectedGpx, long offset) {
        int ret = 0;
        PrimaryDateParser dateParser = new PrimaryDateParser();
        for (GpxTrack trk : selectedGpx.tracks) {
            for (Collection segment : trk.trackSegs) {
                long prevDateWp = 0L;
                WayPoint prevWp = null;
                for (WayPoint curWp : segment) {
                    String curDateWpStr = (String)curWp.attr.get("time");
                    if (curDateWpStr != null) {
                        try {
                            long curDateWp = dateParser.parse(curDateWpStr).getTime() / 1000L + offset;
                            ret += this.matchPoints(dateImgLst, prevWp, prevDateWp, curWp, curDateWp);
                            prevWp = curWp;
                            prevDateWp = curDateWp;
                        }
                        catch (ParseException e) {
                            System.err.println("Error while parsing date \"" + curDateWpStr + '\"');
                            e.printStackTrace();
                            prevWp = null;
                            prevDateWp = 0L;
                        }
                        continue;
                    }
                    prevWp = null;
                    prevDateWp = 0L;
                }
            }
        }
        return ret;
    }

    private int matchPoints(ArrayList<AgpifojLayer.ImageEntry> dateImgLst, WayPoint prevWp, long prevDateWp, WayPoint curWp, long curDateWp) {
        double interval = prevDateWp > 0L ? (double)((int)Math.abs(curDateWp - prevDateWp)) : 1.0;
        int ret = 0;
        int i = this.getLastIndexOfListBefore(dateImgLst, curDateWp, interval);
        if (i >= 0 && i < dateImgLst.size() && (double)(dateImgLst.get((int)i).time.getTime() / 1000L) + interval > (double)prevDateWp) {
            Double speed = null;
            Double prevElevation = null;
            Double curElevation = null;
            if (prevWp != null) {
                double distance = this.getDistance(prevWp, curWp);
                speed = new Double(1000.0 * distance / (double)(curDateWp - prevDateWp));
                try {
                    prevElevation = new Double((String)prevWp.attr.get("ele"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                curElevation = new Double((String)curWp.attr.get("ele"));
            }
            catch (Exception e) {
                // empty catch block
            }
            while (i >= 0 && this.inRadius(dateImgLst.get((int)i).time.getTime() / 1000L, curDateWp, interval)) {
                if (dateImgLst.get((int)i).coor == null) {
                    dateImgLst.get((int)i).pos = curWp.eastNorth;
                    dateImgLst.get((int)i).coor = Main.proj.eastNorth2latlon(dateImgLst.get((int)i).pos);
                    dateImgLst.get((int)i).speed = speed;
                    dateImgLst.get((int)i).elevation = curElevation;
                    ++ret;
                }
                --i;
            }
            if (prevDateWp != 0L) {
                long imgDate;
                while (i >= 0 && (imgDate = dateImgLst.get((int)i).time.getTime() / 1000L) > prevDateWp) {
                    if (dateImgLst.get((int)i).coor == null) {
                        dateImgLst.get((int)i).pos = new EastNorth(prevWp.eastNorth.east() + (curWp.eastNorth.east() - prevWp.eastNorth.east()) * (double)(imgDate - prevDateWp) / (double)(curDateWp - prevDateWp), prevWp.eastNorth.north() + (curWp.eastNorth.north() - prevWp.eastNorth.north()) * (double)(imgDate - prevDateWp) / (double)(curDateWp - prevDateWp));
                        dateImgLst.get((int)i).coor = Main.proj.eastNorth2latlon(dateImgLst.get((int)i).pos);
                        dateImgLst.get((int)i).speed = speed;
                        if (curElevation != null && prevElevation != null) {
                            dateImgLst.get((int)i).elevation = prevElevation + (curElevation - prevElevation) * (double)(imgDate - prevDateWp) / (double)(curDateWp - prevDateWp);
                        }
                        ++ret;
                    }
                    --i;
                }
            }
        }
        return ret;
    }

    private int getLastIndexOfListBefore(ArrayList<AgpifojLayer.ImageEntry> dateImgLst, long searchedDate, double interval) {
        int lstSize = dateImgLst.size();
        if (lstSize == 0 || searchedDate < dateImgLst.get((int)0).time.getTime() / 1000L) {
            return -1;
        }
        if ((double)searchedDate - interval > (double)(dateImgLst.get((int)(lstSize - 1)).time.getTime() / 1000L)) {
            return lstSize;
        }
        if (this.inRadius(searchedDate, dateImgLst.get((int)(lstSize - 1)).time.getTime() / 1000L, interval)) {
            return lstSize - 1;
        }
        if (this.inRadius(searchedDate, dateImgLst.get((int)0).time.getTime() / 1000L, interval)) {
            int curIndex = 0;
            while (curIndex + 1 < lstSize && this.inRadius(dateImgLst.get((int)(curIndex + 1)).time.getTime() / 1000L, searchedDate, interval)) {
                ++curIndex;
            }
            return curIndex;
        }
        int curIndex = 0;
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            curIndex = (endIndex + startIndex) / 2;
            long curDate = dateImgLst.get((int)curIndex).time.getTime() / 1000L;
            if ((double)curDate - interval < (double)searchedDate) {
                startIndex = curIndex;
                continue;
            }
            if ((double)curDate + interval > (double)searchedDate) {
                endIndex = curIndex;
                continue;
            }
            while (curIndex + 1 < lstSize && this.inRadius(dateImgLst.get((int)(curIndex + 1)).time.getTime() / 1000L, searchedDate, interval)) {
                ++curIndex;
            }
            return curIndex;
        }
        return startIndex;
    }

    private String formatTimezone(double timezone) {
        StringBuffer ret = new StringBuffer();
        if (timezone < 0.0) {
            ret.append('-');
            timezone = -timezone;
        } else {
            ret.append('+');
        }
        ret.append((long)timezone).append(':');
        int minutes = (int)(timezone % 1.0 * 60.0);
        if (minutes < 10) {
            ret.append('0');
        }
        ret.append(minutes);
        return ret.toString();
    }

    private Float parseTimezone(String timezone) {
        if (timezone.length() == 0) {
            return new Float(0.0f);
        }
        int sgnTimezone = 43;
        StringBuffer hTimezone = new StringBuffer();
        StringBuffer mTimezone = new StringBuffer();
        int state = 1;
        block12: for (int i = 0; i < timezone.length(); ++i) {
            char c = timezone.charAt(i);
            switch (c) {
                case ' ': {
                    if (state == 2 && hTimezone.length() == 0) continue block12;
                    return null;
                }
                case '+': 
                case '-': {
                    if (state == 1) {
                        sgnTimezone = c;
                        state = 2;
                        continue block12;
                    }
                    return null;
                }
                case '.': 
                case ':': {
                    if (state == 2) {
                        state = 3;
                        continue block12;
                    }
                    return null;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (state) {
                        case 1: 
                        case 2: {
                            state = 2;
                            hTimezone.append(c);
                            continue block12;
                        }
                        case 3: {
                            mTimezone.append(c);
                            continue block12;
                        }
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        int h = 0;
        int m = 0;
        try {
            h = Integer.parseInt(hTimezone.toString());
            if (mTimezone.length() > 0) {
                m = Integer.parseInt(mTimezone.toString());
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (h > 12 || m > 59) {
            return null;
        }
        return new Float(((double)h + (double)m / 60.0) * (double)(sgnTimezone == 45 ? -1 : 1));
    }

    public double getDistance(WayPoint p1, WayPoint p2) {
        double p1Lat = p1.latlon.lat() * Math.PI / 180.0;
        double p1Lon = p1.latlon.lon() * Math.PI / 180.0;
        double p2Lat = p2.latlon.lat() * Math.PI / 180.0;
        double p2Lon = p2.latlon.lon() * Math.PI / 180.0;
        double ret = Math.atan2(Math.sqrt(Math.pow(Math.cos(p2Lat) * Math.sin(p2Lon - p1Lon), 2.0) + Math.pow(Math.cos(p1Lat) * Math.sin(p2Lat) - Math.sin(p1Lat) * Math.cos(p2Lat) * Math.cos(p2Lon - p1Lon), 2.0)), Math.sin(p1Lat) * Math.sin(p2Lat) + Math.cos(p1Lat) * Math.cos(p2Lat) * Math.cos(p2Lon - p1Lon)) * 6372795.0;
        return ret;
    }

    private boolean inRadius(long time1, long time2, double interval) {
        return (double)Math.abs(time1 - time2) < interval;
    }

    private class SetOffsetActionListener
    implements ActionListener {
        JPanel panel;
        JLabel lbExifTime;
        JTextField tfGpsTime;
        JComboBox cbTimezones;
        ImageDisplay imgDisp;
        JList imgList;

        private SetOffsetActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            String[] tmp;
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)new JLabel(I18n.tr((String)"<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>")), "North");
            this.imgDisp = new ImageDisplay();
            this.imgDisp.setPreferredSize(new Dimension(300, 225));
            this.panel.add((Component)this.imgDisp, "Center");
            JPanel panelTf = new JPanel();
            panelTf.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr((String)"Photo time (from exif):")), gc);
            this.lbExifTime = new JLabel();
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.gridwidth = 2;
            panelTf.add((Component)this.lbExifTime, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr((String)"Gps time (read from the above photo): ")), gc);
            this.tfGpsTime = new JTextField();
            this.tfGpsTime.setEnabled(false);
            this.tfGpsTime.setMinimumSize(new Dimension(150, this.tfGpsTime.getMinimumSize().height));
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            panelTf.add((Component)this.tfGpsTime, gc);
            gc.gridx = 2;
            gc.weightx = 0.2;
            panelTf.add((Component)new JLabel(I18n.tr((String)" [dd/mm/yyyy hh:mm:ss]")), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr((String)"I'm in the timezone of: ")), gc);
            Vector<String> vtTimezones = new Vector<String>();
            for (String tzStr : tmp = TimeZone.getAvailableIDs()) {
                TimeZone tz = TimeZone.getTimeZone(tzStr);
                String tzDesc = new StringBuffer(tzStr).append(" (").append(CorrelateGpxWithImages.this.formatTimezone((double)tz.getRawOffset() / 3600000.0)).append(')').toString();
                vtTimezones.add(tzDesc);
            }
            Collections.sort(vtTimezones);
            this.cbTimezones = new JComboBox(vtTimezones);
            String tzId = Main.pref.get("tagimages.timezoneid", "");
            TimeZone defaultTz = tzId.length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone(tzId);
            this.cbTimezones.setSelectedItem(new StringBuffer(defaultTz.getID()).append(" (").append(CorrelateGpxWithImages.this.formatTimezone((double)defaultTz.getRawOffset() / 3600000.0)).append(')').toString());
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            gc.fill = 2;
            panelTf.add((Component)this.cbTimezones, gc);
            this.panel.add((Component)panelTf, "South");
            JPanel panelLst = new JPanel();
            panelLst.setLayout(new BorderLayout());
            this.imgList = new JList(new AbstractListModel(){

                public Object getElementAt(int i) {
                    return CorrelateGpxWithImages.this.yLayer.data.get((int)i).file.getName();
                }

                public int getSize() {
                    return CorrelateGpxWithImages.this.yLayer.data.size();
                }
            });
            this.imgList.getSelectionModel().setSelectionMode(0);
            this.imgList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent arg0) {
                    int index = SetOffsetActionListener.this.imgList.getSelectedIndex();
                    SetOffsetActionListener.this.imgDisp.setImage(CorrelateGpxWithImages.this.yLayer.data.get((int)index).file);
                    Date date = CorrelateGpxWithImages.this.yLayer.data.get((int)index).time;
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(new SimpleDateFormat("dd/MM/yyyy ").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setCaretPosition(SetOffsetActionListener.this.tfGpsTime.getText().length());
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr((String)"No date"));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            panelLst.add((Component)new JScrollPane(this.imgList), "Center");
            JButton openButton = new JButton(I18n.tr((String)"Open an other photo"));
            openButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JFileChooser fc = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                    fc.setAcceptAllFileFilterUsed(false);
                    fc.setMultiSelectionEnabled(false);
                    fc.setFileSelectionMode(0);
                    fc.setFileFilter(AgpifojPlugin.JPEG_FILE_FILTER);
                    fc.showOpenDialog(Main.parent);
                    File sel = fc.getSelectedFile();
                    if (sel == null) {
                        return;
                    }
                    SetOffsetActionListener.this.imgDisp.setImage(sel);
                    Date date = null;
                    try {
                        date = ExifReader.readTime((File)sel);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(new SimpleDateFormat("dd/MM/yyyy ").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr((String)"No date"));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            panelLst.add((Component)openButton, "Last");
            this.panel.add((Component)panelLst, "Before");
            boolean isOk = false;
            while (!isOk) {
                long delta;
                int answer = JOptionPane.showConfirmDialog(Main.parent, this.panel, I18n.tr((String)"Synchronize time from a photo of the GPS receiver"), 2);
                if (answer == 2) {
                    return;
                }
                try {
                    delta = dateFormat.parse(this.lbExifTime.getText()).getTime() - dateFormat.parse(this.tfGpsTime.getText()).getTime();
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing the date.\nPlease use the requested format"), I18n.tr((String)"Invalid date"), 0);
                    continue;
                }
                String selectedTz = (String)this.cbTimezones.getSelectedItem();
                int pos = selectedTz.lastIndexOf(40);
                tzId = selectedTz.substring(0, pos - 1);
                String tzValue = selectedTz.substring(pos + 1, selectedTz.length() - 1);
                Main.pref.put("tagimages.timezoneid", tzId);
                CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(delta / 1000L));
                CorrelateGpxWithImages.this.tfTimezone.setText(tzValue);
                isOk = true;
            }
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void actionPerformed(ActionEvent arg0) {
            block13: {
                JFileChooser fc = new JFileChooser(Main.pref.get("lastDirectory"));
                fc.setFileSelectionMode(0);
                fc.setAcceptAllFileFilterUsed(false);
                fc.setMultiSelectionEnabled(false);
                fc.setFileSelectionMode(0);
                fc.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".gpx") || f.getName().toLowerCase().endsWith(".gpx.gz");
                    }

                    public String getDescription() {
                        return I18n.tr((String)"GPX Files (*.gpx *.gpx.gz)");
                    }
                });
                fc.showOpenDialog(Main.parent);
                File sel = fc.getSelectedFile();
                if (sel == null) {
                    return;
                }
                try {
                    CorrelateGpxWithImages.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                    Main.pref.put("lastDirectory", sel.getPath());
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        if (!(CorrelateGpxWithImages.this.gpxLst.get(i) instanceof GpxDataWrapper)) continue;
                        GpxDataWrapper wrapper = (GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (!sel.equals(wrapper.file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!sel.getName().equals(wrapper.name)) {
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"File {0} is loaded yet under the name \"{1}\"", (Object[])new Object[]{sel.getName(), wrapper.name}));
                        }
                        return;
                    }
                    GpxData data = null;
                    try {
                        InputStream iStream = sel.getName().toLowerCase().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(sel)) : new FileInputStream(sel);
                        data = new GpxReader((InputStream)iStream, (File)sel).data;
                        data.storageFile = sel;
                    }
                    catch (SAXException x) {
                        x.printStackTrace();
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing {0}", (Object[])new Object[]{sel.getName()}) + ": " + x.getMessage());
                        CorrelateGpxWithImages.this.panel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read \"{0}\"", (Object[])new Object[]{sel.getName()}) + "\n" + x.getMessage());
                        CorrelateGpxWithImages.this.panel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    loadedGpxData.add(data);
                    if (CorrelateGpxWithImages.this.gpxLst.get(0) instanceof String) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                    }
                    CorrelateGpxWithImages.this.gpxLst.add(new GpxDataWrapper(sel.getName(), data, sel));
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.panel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class GpxDataWrapper {
        String name;
        GpxData data;
        File file;

        public GpxDataWrapper(String name, GpxData data, File file) {
            this.name = name;
            this.data = data;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class CorrelateParameters {
        GpxData gpxData;
        float timezone;
        long offset;
    }
}

