/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.openLayers;

import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.lobobrowser.util.Urls;
import org.openstreetmap.josm.plugins.openLayers.StorageManager;

public class HttpResponse
implements Serializable {
    private static final long serialVersionUID = -8605486951415515445L;
    protected int status;
    protected String statusText;
    protected byte[] responseBytes;
    protected String encoding;
    protected boolean loaded = false;
    protected Map<String, List<String>> responseHeadersMap;
    protected String responseHeaders;

    public synchronized void setConnectionInfo(URLConnection c) {
        this.encoding = Urls.getCharset(c);
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
        }
        this.responseHeaders = this.getAllResponseHeaders(c);
        this.responseHeadersMap = c.getHeaderFields();
    }

    public synchronized void changeState(int status, String statusMessage, byte[] bytes) {
        this.status = status;
        this.statusText = statusMessage;
        this.responseBytes = bytes;
    }

    private String getAllResponseHeaders(URLConnection c) {
        String value;
        int idx = 0;
        StringBuffer buf = new StringBuffer();
        while ((value = c.getHeaderField(idx)) != null) {
            String key = c.getHeaderFieldKey(idx);
            if (key != null) {
                buf.append(key);
                buf.append("=");
            }
            buf.append(value);
            buf.append("\n");
            ++idx;
        }
        return buf.toString();
    }

    public void store(URL requestURL) {
        this.loaded = true;
        StorageManager.getInstance().put(requestURL, this);
    }

    public static HttpResponse lookup(URL requestURL) {
        return StorageManager.getInstance().get(requestURL);
    }
}

